package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.user.org.OrgDlrResultDTO;
import cn.gtmap.hlw.core.dto.user.org.OrgDlrSaveParamDTO;
import cn.gtmap.hlw.core.model.GxYyOrgDlr;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
 * @version 1.0, 2025/10/11
 * @description 部门代理人数据库访问层
 */
public interface GxYyOrgDlrRepository {

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 更新
     */
    void update(GxYyOrgDlr gxYyOrgDlr);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 保存
     */
    String save(GxYyOrgDlr gxYyOrgDlr);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 根据部门id查询部门代理人
     */
    List<GxYyOrgDlr> getGxYyOrgDlrByOrgId(String orgId);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 删除部门代理人
     */
    void delete(GxYyOrgDlr gxYyOrgDlr);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 查询代理人信息
     */
    List<GxYyOrgDlr> queryDlr(Map<String, Object> map);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 查询代理人信息分页
     */
    PageInfo<GxYyOrgDlr> queryPage(OrgDlrSaveParamDTO paramsDTO);
}
