package cn.gtmap.hlw.core.dto.third.cqzdyxx.ygxx;

import lombok.Data;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2024/1/2 15:14
 * @description 5.4.19    根据权利人和权利人证号、预告证明号获取预告信息（包括预告和预告抵押）
 */
@Data
public class BdcYgxxThirdParamsDTO {

    /**
     * 步骤id
     */
    private String processId;
    /**
     * 领域事件代码
     */
    private String lysjdm;
    /**
     * 机构代码
     */
    private String orgId;
    /**
     * 权利人名称（证书权利人之一）
     */
    private String qlrmc;

    /**
     * 权利人证件号
     */
    private String qlrzjh;

    /**
     * 抵押人名称
     */
    private String dyrmc;

    /**
     * 抵押人证件号
     */
    private String dyrzjh;

    /**
     * 预告证明号 精确
     */
    private String ygzmh;
    /**
     * 预告证明号 模糊
     */
    private String ygzmhmh;

    /**
     * 坐落 精确
     */
    private String zl;
    /**
     * 坐落 模糊
     */
    private String zlmh;

    /**
     * 不动产单元号
     */
    private String bdcdyh;

    /**
     * 预告证明号简称
     */
    private String ygzmhjc;

    /**
     * 区域代码
     */
    private String qydm;
    /**
     * 不动产单元编号
     */
    private String bdcdybh;

}
