package cn.gtmap.hlw.core.dto.sqxx.push.dj3.dyzy;


import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import cn.gtmap.hlw.core.dto.sqxx.push.dj3.WxblxxQueryBO;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2024/4/8 13:36
 * @description 登记3.0 转移抵押合并流程创建入参
 */
@Data
public class PushDj3DyZyQlrxxParamsBO {
    /**
     * 权利人代理人
     */
    private String qlrdlr;
    /**
     * 权利人代理人联系电话
     */
    private String qlrdlrlxdh;
    /**
     * 权利人代理人证件种类
     */
    private String qlrdlrzjzl;
    /**
     * 权利人代理人证件号
     */
    private String qlrdlrzjh;
    /**
     * 权利人类型
     */
    @ZdDzConfig(field = "qlrlx", tableName = ZdDzConstant.ZD_DZ_QLRLX, dmToDm = true)
    private String qlrlx;
    /**
     * 权利人名称
     */
    private String qlrmc;
    /**
     * 权利人身份证件种类
     */
    private String qlrsfzjzl;
    /**
     * 税号
     */
    private String sh;
    /**
     * 联系电话
     */
    private String qlrlxdh;
    /**
     * 共有方式
     */
    @ZdDzConfig(field = "gyfs", tableName = ZdDzConstant.ZD_DZ_GYFS, dmToDm = true)
    private String gyfs;
    /**
     * 是否本地户籍
     */
    private String sfbdhj;
    /**
     * 税款减免
     */
    private String skjm;
    /**
     * 房产证号
     */
    private String fczh;
    /**
     * 房屋套次
     */
    private String fwtc;
    /**
     * 共有比例
     */
    private String gybl;
    /**
     * 婚姻状态
     */
    private String hyzt;
    /**
     * 家庭成员
     */
    private List<PushDj3DyZyQlrJtcyParamsBO> jtcy;
    /**
     * 权利人证件号
     */
    private String qlrzjh;
    /**
     * 权利人种类代码
     */
    private String qlrzldm;
    /**
     * 权利人种类名称
     */
    private String qlrzlmc;
    /**
     * 权利人执行人
     */
    private String qlrzxr;
    /**
     * 权利人执行人联系电话
     */
    private String qlrzxrzlxdh;
    /**
     * 权利人执行人证件种类
     */
    private String qlrzxrzjzl;
    /**
     * 权利人执行人证件号
     */
    private String qlrzxrzjh;
    /**
     * 持证方式代码
     */
    private String czfsdm;
    /**
     * 持证方式名称
     */
    private String czfsmc;
    /**
     * 顺序号
     */
    private String sxh;
    /**
     * 抵押权人类别
     */
    private String dyqrlb;
    /**
     * 是否月结
     */
    private String sfyj;
    /**
     * 权利人法定代表人
     */
    private String qlrfddbr;
    /**
     * 权利人法定代表人联系电话
     */
    private String qlrfddbrlxdh;
    /**
     * 权利人法定代表人证件种类代码
     */
    @ZdDzConfig(field = "qlrfddbrzjzl", tableName = ZdDzConstant.ZD_DZ_ZJLX, dmToDm = true)
    private String qlrfddbrzjzl;
    /**
     * 权利人法定代表人证件种类名称
     */
    private String qlrfddbrzjzlmc;
    /**
     * 权利人法定代表人证件号
     */
    private String qlrfddbrzjh;
    /**
     * 是否小微企业
     */
    private String sfxwqy;
    /**
     * 现有住房坐落
     */
    private List<PushDj3DyZyXyzfzlParamsBO> xyzfzlList;
    /**
     * 权利人代理人信息
     */
    @ZdDzConfig(field = "qlrdlrxx", tableName = "", isList = true)
    private List<PushDj3DyZyQlrDlrParamsBO> qlrdlrxx;
    /**
     * 是否持证人
     */
    private String sfczr;

    /**
     * 证件类型判断，如果是6：组织机构代码，或者7：营业执照 ，那么权利人种类代码	qlrzldm：2   qlrzlmc：企业；否则为qlrzldm：1 qlrzlmc：个人，如果为空默认为1个人
     * 关系人种类代码	gxrzldm	字符串				1个人、2企业，放代码
     * 关系人种类名称	gxrzlmc	字符串				个人、企业，放名称
     */
    private String gxrzldm;
    private String gxrzlmc;
    /**
     * 问询笔录信息
     */
    private List<WxblxxQueryBO> wxblxx;
}
