/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiSecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(ApiSecurityUtils.class);

    public static String decrypt(String sm4KeyBySm2, String decryptStr) {
        String sm4Key = Sm2lib.decode(sm4KeyBySm2);
        return Sm4Util.decryptEcb(sm4Key, decryptStr);
    }

    public static ApiEncryptBody encrypt(String encryptStr, String frontPublicKey) {
        String sm4Key = null;
        try {
            sm4Key = Sm4Util.generateKey();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String data = Sm4Util.encryptEcbByHutool(sm4Key, encryptStr);
        ApiEncryptBody apiEncryptRes = new ApiEncryptBody();
        apiEncryptRes.setParamid(Sm2lib.encode(sm4Key, frontPublicKey));
        apiEncryptRes.setData(data);
        apiEncryptRes.setFrontKey(frontPublicKey);
        return apiEncryptRes;
    }

    public static void main(String[] args) throws Exception {
        String pubKey = "c2f1831616943efe504bde6b45d59eea953f04d31ecebd4c59dffd6733c7a066c7a9c14cb2c54564187891f72753fea7f56d07b19d52e9076263564def41b8e7";
        String dataEncrypt = "a70c7735f5e93a2899434110380393c452096921b97ba4fe25ec64d4a3b265622d446c05b30ea4b36a911d9fc1f7a39a495fe8cd9a695de0d904a23ed3967302";
        String paramid = "046e3fe1f14\nab6391a2aa9ac7f24a4f11d20d7831ff202518925020d8a3e79c84e3bc8ebe190d13d8ab35815adf5771aa270e07280da085874f656e4d4508467bf13643198d917401c440822ac335185872e9601d8be6fdd089aaab46e97bb97247f7e2800c22b2524d92ab6e0a3ad7dc50d4ea52edc3ca51208b8f95e8eaa5adffb5589994a80ea50f8fad19c";
        String qdData = ApiSecurityUtils.decrypt(paramid, dataEncrypt);
        System.out.println(qdData);
    }
}

