package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.dict.an.ZdAnListParamsDTO;
import cn.gtmap.hlw.core.model.GxYyZdAn;

import java.util.List;

/**
 * 页面按钮字典表(GxYyZdAn)表数据库访问层
 *
 * @author makejava
 * @since 2023-11-16 09:07:34
 */
public interface GxYyZdAnRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param anid 主键
     * @return 实例对象
     */
    GxYyZdAn get(String anid);

    /**
     * 新增数据
     *
     * @param gxYyZdAn 实例对象
     * @return 影响行数
     */
    void save(GxYyZdAn gxYyZdAn);

    /**
     * 批量新增或修改
     */
    void saveOrUpdateBatch(List<GxYyZdAn> zdAnList);

    /**
     * 修改数据
     *
     * @param gxYyZdAn 实例对象
     * @return 影响行数
     */
    void update(GxYyZdAn gxYyZdAn);

    /**
     * 新增或修改
     */
    void saveOrUpdate(GxYyZdAn gxYyZdAn);

    /**
     * 按钮下拉框
     * @param paramsDTO
     * @return
     */
    List<GxYyZdAn> list(ZdAnListParamsDTO paramsDTO);

    /**
     * 根据主键集合查询
     */
    List<GxYyZdAn> listByAnIds(List<String> anIdList);

    /**
     * 删除
     */
    void delete(String anid);

    /**
     * 分页查询
     */
    PageInfo<GxYyZdAn> queryPage(ZdAnListParamsDTO paramsDTO);
}

