package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.djzx.DjzxAllQueryParamsDTO;
import cn.gtmap.hlw.core.dto.djzx.DjzxQueryDTO;
import cn.gtmap.hlw.core.model.GxYyDjzx;
import cn.gtmap.hlw.core.model.query.DjzxQueryParamsModel;

import java.util.List;

/**
 * 登记中心配置(GxYyDjzx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-29 10:19:06
 */
public interface GxYyDjzxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param djzxdm 主键
     * @return 实例对象
     */
    GxYyDjzx get(String djzxdm);

    /**
     * 新增数据
     *
     * @param gxYyDjzx 实例对象
     */
    void save(GxYyDjzx gxYyDjzx);

    /**
     * 保存或更新数据
     *
     * @param gxYyDjzx 实例对象
     */
    void saveOrUpdate(GxYyDjzx gxYyDjzx);

    /**
     * 修改数据
     *
     * @param gxYyDjzx 实例对象
     */
    void update(GxYyDjzx gxYyDjzx);

    /**
     * 修改是否使用
     *
     * @param paramsDTO 参数对象
     */
    void updateSfyy(DjzxQueryDTO paramsDTO);

    /**
     * 修改数据
     *
     * @return 影响行数
     */
    List<GxYyDjzx> getDjzxList();

    /**
     * 查询数据
     * @param  paramsDTO
     * @return 影响行数
     */
    List<GxYyDjzx> getDjzxListByQydm(DjzxAllQueryParamsDTO paramsDTO);

    /**
     * 获取数据
     * @param  xzqydmList
     * @return list
     */
    List<GxYyDjzx> getByXzqydm(List<String> xzqydmList);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 登记中心查询
     */
    List<GxYyDjzx> query(DjzxQueryParamsModel paramsModel);
    /**
     * 根据部门id查询
     * @param orgId
     * @return:cn.gtmap.hlw.core.model.GxYyDjzx
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyDjzx getByShOrgId(String orgId);

    /**
     * 删除登记中心
     *
     * @param djzxdm 登记中心代码
     */
    void delete(String djzxdm);

    /**
     * 分页查询登记中心
     *
     * @param queryDTO 查询参数
     * @return 分页结果
     */
    PageInfo<GxYyDjzx> page(DjzxQueryDTO queryDTO);
}

