package cn.gtmap.hlw.core.dto.third.cqxx;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.dto.sqxx.save.*;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/8 13:50
 * @description HtxxManageResultDTO
 */
@Data
public class CqxxThirdResultDTO {
    /**
     * 查询唯一标识
     */
    private String rowguid;
    /**
     * 入参区域代码（前端传入的区域代码）
     */
    private String rcqydm;
    private String qjgldm;
    /**
     * 房产证号
     */
    private String fczh;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 坐落
     */
    private String zl;
    /**
     * 面积
     */
    private String mj;
    /**
     * 是否抵押 0:是  1:否
     */
    private String sfdy;
    /**
     * 是否查封 0:是  1:否
     */
    private String sfcf;
    /**
     * 是否居住权 0:是  1:否
     */
    private String sfjzq;
    /**
     * 是否预告 0:是  1:否
     */
    private String sfyg;
    /**
     * 是否预抵押 0:是  1:否
     */
    private String sfydy;
    /**
     * 不动产单元编号
     */
    private String bdcdybh;
    /**
     * 证书来源
     */
    private String zsly;
    /**
     * 项目id
     */
    private String xmid;
    /**
     * 房屋结构
     */
    private String fwjg;
    /**
     * 房屋结构
     */
    private String fwjgmc;
    /**
     * 房屋用途名称
     */
    private String fwytmc;
    /**
     * 房屋类型(代码)
     */
    private String fwlx;
    /**
     * 房屋类型(代码)
     */
    private String fwlxmc;
    /**
     * 规划用途(代码)
     */
    private String ghyt;
    /**
     * 规划用途(代码)
     */
    private String ghytmc;
    /**
     * 总层数
     */
    private String zcs;
    /**
     * 竣工时间
     */
    private String jgsj;
    /**
     * 建筑年代（份）
     */
    private String jznf;
    /**
     * 房屋性质(代码)
     */
    private String fwxz;
    /**
     * 房屋性质名称
     */
    private String fwxzmc;
    /**
     * 所在层
     */
    private String szc;
    /**
     * 所在名义层
     */
    private String szmyc;
    /**
     * 宗地用途(代码)
     */
    private String zdyt;
    /**
     * 宗地用途名称
     */
    private String zdytmc;
    /**
     * 宗地面积
     */
    private String zdmj;
    /**
     * 宗地/宗海权利性质
     */
    private String zdzhqlxz;
    /**
     * 宗地/宗海权利性质
     */
    private String zdzhqlxzmc;
    /**
     * 土地使用权类型
     */
    private String tdsyqlx;
    /**
     * 土地使用权类型
     */
    private String tdsyqlxmc;
    /**
     * 区域代码
     */
    private String qydm;
    /**
     * 区域名称
     */
    private String qymc;
    /**
     * 登记时间 YYYY-MM-DD HH:MM:SS
     */
    private String djsj;
    /**
     * roomid
     */
    private String roomid;
    /**
     * 是否异议 0:否  1:是
     */
    private String sfyy;
    /**
     * 附件
     */
    private String fj;
    /**
     * 权利类型;字典项
     */
    private String qllx;
    /**
     * 权利类型;字典项
     */
    private String qllxmc;
    private String fwmc;
    private String tnjzmj;
    private String fwzh;
    private String fwfh;
    private String fttdmj;
    private String sctnmj;
    private String sfblysgg;
    private String zszl;
    private String tdsyqssj;
    private String tdsyjssj;
    private String djyy;
    private String djyymc;
    private String sfsd;
    private String yxmid;
    private String tdzh;
    private String dytdmj;
    private String scftmj;
    private String szxzjd;
    private String bdclx;
    private String bdclxmc;
    private String qdjg;
    private String qlslqk;
    private String cqly;
    private String cqlymc;
    private String tdsyqssj2;
    private String tdsyjssj2;
    private String tdsyqssj3;
    private String tdsyjssj3;
    private String syqx;
    private String qjzl;
    private String zdytdm2;
    private String zdytmc2;
    private String zdytdm3;
    private String zdytmc3;
    private String jzqqk;
    private String qsxzdm;
    private String qsxzmc;
    private String glmj;
    private String ccsmj;
    private String qcckml;
    private String qdfs;
    private String fwdyh;
    private String scqdfwsj;
    private String scqdfwcb;
    private String sfyzdf;
    private String zdzhqllx;
    private String scjzmj;
    private String tdsyqr;
    /**
     * 权利人名称
     */
    private String qlrmc;
    /**
     * 权利人证件号
     */
    private String qlrzjh;
    /**
     * 缴费状态代码
     */
    private String jfztdm;
    /**
     * 土地信息
     */
    private TdxxDTO fwtdxx;
    /**
     * 土地承包经营
     */
    private TdcbjyDTO tdcbjy;
    /**
     * 土地承包经营地块信息
     */
    private TdcbjydkxxDTO tdcbjydkxx;
    @ZdDzConfig(field = "qlrList", tableName = "", isList = true)
    private List<CqxxThirdQlrDTO> qlrList;
    private List<CqxxThirdFsssxxDTO> fsssxxList;
    private List<CqxxThirdFwfzxxDTO> fwfzxxList;
    /**
     * 授权id
     */
    private String uuid;
    /**
     * 授权结果
     */
    private Integer sqjg;
    /**
     * 授权结果名称
     */
    private String sqjgmc;


    /**
     * 权利设定方式dm
     */
    private String qlsdfs;
    /**
     * 登记受理编号
     */
    private String djslbh;

    /**
     * 证照标识
     */
    private String zzbs;
    /**
     * 发证时间
     */
    private String fzsj;
    /**
     * 小区名称
     */
    private String xqmc;
    /**
     * 发证日期
     */
    private String fzrq;
    /**
     * 乡镇街道代码
     */
    private String xzjddm;
    /**
     * 乡镇街道名称
     */
    private String xzjdmc;
    /**
     * 抵押信息
     */
    private List<DyxxDTO> dyxxList;
    /**
     * 查封信息
     */
    private List<CfxxDTO> cfxxList;
    /**
     * 异议信息
     */
    private List<YiyixxDTO> yiyixxList;

}
