package cn.gtmap.hlw.coredk.enums;

import cn.gtmap.hlw.core.enums.dict.fj.FjlxEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
 * @version 1.0 2025/5/22
 * @description
 */

@Getter
@AllArgsConstructor
public enum DzkfFjlxEnum {
    FJLX_DJDCSQS(603, "地籍调查申请书"),
    FJLX_SJDPZ(985, "收件单"),
    FJLX_SQRSFZM(982, "申请人身份证明"),
    FJLX_DJZLDJB(982, "登记簿"),
    FJLX_WTCL(20250604, "委托材料"),
    FJLX_HYQK(20250605, "婚姻情况"),
    FJLX_ZYHT(1108, "赠与合同");
    @Getter
    private Integer code;

    @Getter
    private String msg;

    public static String getMsg(String code) {
        for (FjlxEnum xq : FjlxEnum.values()) {
            if (xq.getCode().toString().equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
