package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;


/**
 * (hlw_sqxx_slxx)互联网申请信息受理信息model
 *
 * @author makejava
 * @since 2023-10-12 17:44:48
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HlwSqxxSlxx implements Serializable {

    /**
     * 主键
     */
    private String slid;
    /**
     * 受理编号
     */
    private String slbh;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 不动产坐落
     */
    private String zl;
    /**
     * 互联网的申请类型代码，组合流程放大类
     */
    private String sqlxdm;
    /**
     * 申请状态 0：未审核，1：审核中，2：已通过，3：未通过，4：预审通过，5：预审未通过，6：用户撤回，7：办结，8：会签通过，9：已审核，10：会签不通过
     */
    private Integer slztdm;
    /**
     * 申请信息来源，1为微信，3为APP，2为web,4为其他
     */
    private Integer sqxxly;
    /**
     * 区县代码
     */
    private String qxdm;
    /**
     * 业务系统受理编号（业务系统返回值）
     */
    private String ywxtslbh;
    /**
     * 创建用户
     */
    private String cjyh;
    /**
     * 创建人员(gx_yy_user.USER_GUID)
     */
    private String cjyhid;
    /**
     * 创建日期
     */
    private Date cjsj;
    /**
     * 创建人所在部门
     */
    private String cjyhszbmid;
    /**
     * 税务状态（gx_yy_zd_type.ZD_TYPE=SWZT）
     */
    private String swztdm;
    /**
     * 缴费状态代码(0：未缴费  1：已缴费,2:已退款，3:退款中，4：已取消，5：集中缴费，6：无需缴费，7：已挂账)
     */
    private String jfztdm;
    /**
     * 云签状态(1：未签署，2：已签署或者免签署）
     */
    private String yqztdm;
    /**
     * 登记接收人名称
     */
    private String djjsrmc;
    /**
     * 登记接收人ID
     */
    private String djjsrid;
    /**
     * 权利人名称（冗余字段，名称以逗号隔开）
     */
    private String qlrmc;
    /**
     * 权利人证件号（冗余字段，以逗号隔开）
     */
    private String qlrzjh;
    /**
     * 义务人名称（冗余字段，以逗号隔开）
     */
    private String ywrmc;
    /**
     * 义务人证件号（冗余字段，以逗号隔开）
     */
    private String ywrzjh;
    /**
     * 权利人名称2（冗余字段，名称以逗号隔开）
     */
    private String qlrmc2;
    /**
     * 权利人证件号2（冗余字段，以逗号隔开）
     */
    private String qlrzjh2;
    /**
     * 义务人名称2（冗余字段，以逗号隔开）
     */
    private String ywrmc2;
    /**
     * 义务人证件号2（冗余字段，以逗号隔开）
     */
    private String ywrzjh2;
    /**
     * 原不动产权证证号
     */
    private String ybdcqzh;
    /**
     * 原土地证号
     */
    private String ytdzh;
    /**
     * 原房产证号
     */
    private String yfczh;

}

