package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/7/13
 * @description 信息类型
 */
@Getter
@AllArgsConstructor
public enum XxlxEnum {
    /**
     * 在线申请核验通知
     */
    XXLX_ZXSQHYTZ("1001", "在线申请核验通知"),
    /**
     * 在线申请预审结果通知
     */
    XXLX_ZXSQYSJGTZ("1002", "在线申请预审结果通知"),
    /**
     * 在线申请撤回结果通知
     */
    XXLX_ZXSQCHJGTZ("1003", "在线申请撤回结果通知"),
    /**
     * 登记审核结果通知
     */
    XXLX_DJSHJGTZ("1004", "登记审核结果通知"),
    /**
     * 申请信息推送至登记系统结果通知
     */
    XXLX_SQXXTSDJXTJGTZ("1005", "申请信息推送至登记系统结果通知"),
    /**
     * 预约过期通知
     */
    XXLX_YYGQTZ("1006", "预约过期通知"),
    /**
     * 核验不通过
     */
    XXLX_HYBTG("1007", "核验不通过"),
    /**
     * 用户撤回申请
     */
    XXLX_YYCHSQ("1008", "用户撤回申请"),
    /**
     * 银行查询电子证照
     */
    XXLX_YHCXDZZZ("1009", "银行查询电子证照"),
    /**
     * 我的建议回复通知
     */
    XXLX_WDJYHFTZ("1010", "我的建议回复通知"),
    /**
     * 税务驳回通知
     */
    XXLX_SWBHTZ("1011", "税务驳回通知"),
    /**
     * 人脸识别待认证通知
     */
    XXLX_RLSBDRZTZ("1012", "人脸识别待认证通知");


    @Getter
    String code;
    @Getter
    String msg;

    public static String getMsg(String dm) {
        for (XxlxEnum xq : XxlxEnum.values()) {
            if (xq.code.equals(dm)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
