/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.file;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfToImageUtils {
    private static final Logger log = LoggerFactory.getLogger(PdfToImageUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String pdfToPic(byte[] fileContent, String wjlx, String pdfExchangeDpi) {
        try (PDDocument document = PDDocument.load((byte[])fileContent);){
            PDFRenderer renderer = new PDFRenderer(document);
            int actSize = document.getNumberOfPages();
            float dpi = 80.0f;
            if (StringUtils.isNotBlank((CharSequence)pdfExchangeDpi)) {
                dpi = Float.parseFloat(pdfExchangeDpi);
            }
            ArrayList<BufferedImage> piclist = new ArrayList<BufferedImage>();
            for (int i = 0; i < document.getNumberOfPages(); ++i) {
                BufferedImage image = renderer.renderImageWithDPI(i, dpi);
                piclist.add(image);
                if (piclist.size() < 10) continue;
                byte[] result = PdfToImageUtils.pjPic(piclist, wjlx);
                piclist.clear();
            }
            if (piclist.isEmpty()) return null;
            byte[] result = PdfToImageUtils.pjPic(piclist, wjlx);
            String string = result == null ? null : Base64.getEncoder().encodeToString(result);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] pjPic(List<BufferedImage> piclist, String wjlx) {
        if (piclist == null || piclist.size() <= 0) {
            log.info("\u56fe\u7247\u6570\u7ec4\u4e3a\u7a7a!");
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int height = 0;
            int width = 0;
            int heightTemp = 0;
            int heightEach = 0;
            int picNum = piclist.size();
            Object fileImg = null;
            int[] heightArray = new int[picNum];
            BufferedImage buffer = null;
            ArrayList<int[]> imgRGB = new ArrayList<int[]>();
            for (int i = 0; i < picNum; height += heightTemp, ++i) {
                buffer = piclist.get(i);
                heightArray[i] = heightTemp = buffer.getHeight();
                if (i == 0) {
                    width = buffer.getWidth();
                }
                int[] imgRGBTemp = new int[width * heightTemp];
                imgRGBTemp = buffer.getRGB(0, 0, width, heightTemp, imgRGBTemp, 0, width);
                imgRGB.add(imgRGBTemp);
            }
            heightTemp = 0;
            BufferedImage imageResult = new BufferedImage(width, height, 1);
            for (int i = 0; i < picNum; ++i) {
                heightEach = heightArray[i];
                if (i != 0) {
                    heightTemp += heightEach;
                }
                imageResult.setRGB(0, heightTemp, width, heightEach, (int[])imgRGB.get(i), 0, width);
            }
            ImageIO.write((RenderedImage)imageResult, wjlx, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

