package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.dict.sqlx.ZdSqlxPageParamsDTO;
import cn.gtmap.hlw.core.model.GxYyZdSqlx;

import java.util.List;

/**
 * 不动产申请类型字典表(GxYyZdSqlx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 16:38:58
 */
public interface GxYyZdSqlxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyZdSqlx get(String id);

    /**
     * 通过ID查询单条数据
     *
     * @param sqlxList sqlx集合
     * @return 实例对象
     */
    List<GxYyZdSqlx> getSqlxBySqlxdmList(List<String> sqlxList);

    /**
     * 新增数据
     *
     * @param gxYyZdSqlx 实例对象
     * @return 影响行数
     */
    void save(GxYyZdSqlx gxYyZdSqlx);

    /**
     * 修改数据
     *
     * @param gxYyZdSqlx 实例对象
     * @return 影响行数
     */
    void update(GxYyZdSqlx gxYyZdSqlx);

    /**
     * 根据roleId查询申请类型（所有）字典
     *
     * @param roleId 角色id
     * @return 影响行数
     */
    List<GxYyZdSqlx> getSqlxByRoleId(String roleId);

    /**
     * 获取所有
     *
     * @return 影响行数
     */
    List<GxYyZdSqlx> getAll();

    /**
     * 查询子申请类型
     *
     * @param sqlx
     * @return
     */
    List<GxYyZdSqlx> getZsqlxBySubdm(String sqlx);

    /**
     * 查询转移申请登记小类
     *
     * @param sqlxdm
     * @return
     */
    String getZysqDjxlBySqlxdm(String sqlxdm);

    /**
     * 根据类型查询申请类型（所有）字典
     *
     * @param sqlxdm 申请类型代码
     * @return 影响行数
     */
    GxYyZdSqlx getRedisSqlxBySqlxdm(String sqlxdm);

    /**
     * 根据类型查询申请类型（所有）字典
     * @param sqlxList
     * @return
     */
    List<GxYyZdSqlx> getRedisSqlxBySqlxdmList(List<String> sqlxList);

    /**
     * 根据大类sqlx查询申请类型（所有）
     *
     * @param sqlx 申请类型代码
     * @return 影响行数
     */
    List<String> getSqlxListBySqlx(String sqlx);

    /**
     * 分页查询申请类型
     *
     * @param paramsDTO
     * @return
     */
    PageInfo<GxYyZdSqlx> page(ZdSqlxPageParamsDTO paramsDTO);

    /**
     * 删除
     *
     * @param id
     * @return 删除的条数
     */
    int delete(String id);

    /**
     * 批量删除
     *
     * @param sqlxList
     * @return
     */
    int deleteBatchIds(List<String> sqlxList);
}

