package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxZjxx;

import java.util.List;

/**
 * 申请信息中介信息(GxYySqxxZjxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:51
 */
public interface GxYySqxxZjxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYySqxxZjxx get(String id);

    /**
     * 通过ID查询单条数据
     *
     * @param sqid 主键
     * @return 实例对象
     */
    List<GxYySqxxZjxx> list(String sqid);

    /**
     * 通过slbh查询数据
     *
     * @param slbh 主键
     * @return 实例对象
     */
    List<GxYySqxxZjxx> getBySlbh(String slbh);

    /**
     * 新增数据
     *
     * @param gxYySqxxZjxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxZjxx gxYySqxxZjxx);

    /**
     * 修改数据
     *
     * @param gxYySqxxZjxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxZjxx gxYySqxxZjxx);

    /**
     * 删除数据
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    ///void delete(String slbh);

    /**
     * 新增或修改数据
     *
     * @param gxYySqxxZjxx 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYySqxxZjxx gxYySqxxZjxx);

    /**
     * 通过sqidList查询集合数据
     *
     * @param sqidList
     * @return 实例对象
     */
    List<GxYySqxxZjxx> getBySqidList(List<String> sqidList);

    /**
     * 通过sqidList删除集合数据
     *
     * @param sqidList
     * @return 实例对象
     */
    int deleteBySqidList(List<String> sqidList);

    /**
     * sqid查询数据
     *
     * @param sqid
     * @return 实例对象
     */
    GxYySqxxZjxx getBySqid(String sqid);
}

