/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.config;

import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.http.HttpContextUtils;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(ParameterRequestWrapper.class);
    private static final Logger logger = LoggerFactory.getLogger(ParameterRequestWrapper.class);
    private Map<String, String[]> params = new HashMap<String, String[]>();

    public ParameterRequestWrapper(HttpServletRequest request) {
        super(request);
        this.params.putAll(request.getParameterMap());
    }

    public ParameterRequestWrapper(HttpServletRequest request, Map<String, Object> extendParams) {
        super(request);
        if (Objects.isNull(extendParams)) {
            extendParams = HttpContextUtils.getParameterMapAll(request);
        }
        this.addAllParameters(extendParams);
    }

    public Enumeration<String> getParameterNames() {
        return new Vector<String>(this.params.keySet()).elements();
    }

    public String getParameter(String name) {
        String[] values = this.params.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        return this.params.get(name);
    }

    public void addAllParameters(Map<String, Object> otherParams) {
        for (Map.Entry<String, Object> entry : otherParams.entrySet()) {
            this.addParameter(entry.getKey(), entry.getValue());
        }
    }

    public void addParameter(String name, Object value) {
        if (value != null) {
            if (value instanceof String[]) {
                this.params.put(name, (String[])value);
            } else if (value instanceof String) {
                this.params.put(name, new String[]{(String)value});
            } else {
                this.params.put(name, new String[]{String.valueOf(value)});
            }
        }
    }

    public StringBuffer getRequestURL() {
        StringBuffer originalUrl = super.getRequestURL();
        Object[] split = originalUrl.toString().split("/");
        for (int i = split.length - 1; i >= 0; --i) {
            String vale = Sm2lib.decode(split[i]);
            split[i] = vale;
        }
        return new StringBuffer(Joiner.on((String)"/").join(split));
    }

    public String getRequestURI() {
        String originalUrl = super.getRequestURI();
        Object[] split = originalUrl.split("/");
        for (int i = split.length - 1; i >= 0; --i) {
            String vale = Sm2lib.decode(split[i]);
            split[i] = vale;
        }
        originalUrl = Joiner.on((String)"/").join(split);
        return originalUrl;
    }

    public String getServletPath() {
        String originalUrl = super.getServletPath();
        Object[] split = originalUrl.split("/");
        for (int i = split.length - 1; i >= 0; --i) {
            String vale = Sm2lib.decode(split[i]);
            split[i] = vale;
        }
        originalUrl = Joiner.on((String)"/").join(split);
        return originalUrl;
    }

    public ServletInputStream getInputStream() {
        StringBuilder sb = new StringBuilder();
        ServletInputStream inputStream = null;
        BufferedReader reader = null;
        try {
            ServletInputStream servletInputStream;
            inputStream = super.getInputStream();
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
            String line = "";
            while ((line = reader.readLine()) != null) {
                line = Sm2lib.decode(line);
                sb.append(line);
            }
            if (StringUtils.isEmpty((CharSequence)sb)) {
                ServletInputStream servletInputStream2 = null;
                return servletInputStream2;
            }
            ServletInputStream servletInputStream3 = servletInputStream = ParameterRequestWrapper.getServletInputStream(sb);
            return servletInputStream3;
        }
        catch (IOException e) {
            throw new BizException((IError)ErrorEnum.SERVICE_ERROR, "request\u89e3\u6790Body\u8bf7\u6c42\u4fe1\u606f\u5f02\u5e38");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                log.error("\u5173\u95ed\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private static ServletInputStream getServletInputStream(StringBuilder sb) {
        final ByteArrayInputStream finalByteArrayInputStream = new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));
        ServletInputStream servletInputStream = new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return finalByteArrayInputStream.read();
            }
        };
        return servletInputStream;
    }

    public String getInput() {
        StringBuilder sb = new StringBuilder();
        ServletInputStream inputStream = null;
        BufferedReader reader = null;
        try {
            inputStream = super.getInputStream();
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
            String line = "";
            while ((line = reader.readLine()) != null) {
                line = Sm2lib.decode(line);
                sb.append(line);
            }
            if (StringUtils.isEmpty((CharSequence)sb)) {
                String string = null;
                return string;
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new BizException((IError)ErrorEnum.SERVICE_ERROR, "request\u89e3\u6790Body\u8bf7\u6c42\u4fe1\u606f\u5f02\u5e38");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                log.error("\u5173\u95ed\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

