/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.ahwstface;

import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import com.iflytek.uccp.auth.sdk.util.sm3.SM3Digest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    private static final Logger log = LoggerFactory.getLogger(SignUtils.class);

    public static String getSign(TreeMap<String, String> params, String appKey) {
        String s = SignUtils.buildSignData(params, appKey);
        return SM3Digest.sm3Encry((String)s);
    }

    private static String buildSignData(TreeMap<String, String> params, String appKey) {
        StringBuilder data = new StringBuilder();
        int[] index = new int[]{0};
        int size = params.size();
        params.forEach((k, v) -> {
            if (StringUtils.isNotBlank((CharSequence)v)) {
                data.append(k + "=" + v);
                if (index[0] != size - 1) {
                    data.append("&");
                }
            }
            index[0] = index[0] + 1;
        });
        try {
            String signDateStr = URLEncoder.encode(data + appKey, "UTF-8");
            log.debug("\u5f85\u7b7e\u540d\u7684\u5b57\u7b26\u4e32\uff1a{}", (Object)signDateStr);
            return signDateStr;
        }
        catch (UnsupportedEncodingException e) {
            throw new BizException((IError)ErrorEnum.SERVICE_ERROR, (Throwable)e);
        }
    }

    public static void buildPayParams(StringBuilder sb, Map<String, String> payParams, boolean encoding) {
        ArrayList<String> keys = new ArrayList<String>(payParams.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append(key).append("=");
            if (encoding) {
                sb.append(SignUtils.urlEncode(payParams.get(key)));
            } else {
                sb.append(payParams.get(key));
            }
            sb.append("&");
        }
        sb.setLength(sb.length() - 1);
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("urlEncode error:", (Throwable)e);
            return str;
        }
    }
}

