package cn.gtmap.hlw.core.model.CrossRiver;


import cn.gtmap.hlw.core.annotation.Desensitized;
import cn.gtmap.hlw.core.enums.SensitiveTypeEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * @version 1.0, 2019/5/15.
 * @auto <a href="mailto:huangyongkai@gtmap.cn">huangyongkai</a>
 * @description 权利人家庭成员
 */
public class QlrJtcy {
    /**
     * 申请ID
     */
    private String sqid;
    /**
     * 权利人ID
     */
    private String qlrid;
    /**
     * 家庭成员名称
     */
    @Desensitized(type = SensitiveTypeEnum.CHINESE_NAME)
    private String jtcymc;
    /**
     * 家庭成员证件号
     */
    @Desensitized(type = SensitiveTypeEnum.ID_CARD, isEncrypter = true)
    private String jtcyzjh;
    /**
     * 家庭成员证件种类
     */
    //@DictConversion(type = DataDictUtils.table_zjlx, rule = DataDictUtils.GETMCBYDM)
    private String jtcyzjzl;
    /**
     * @author <a href="mailto:huangyongkai@gtmap.cn">huangyongkai</a>
     * @description 代码转换成名称
     */
    private String jtcyzjzlMc;
    /**
     * 与买（卖）家关系
     */
    private String jtgx;
    private String jtgxmc;
    /**
     * 家庭成员婚姻状态(zd_type=HYZT)
     */
    private String jtcyhyzt;
    private String jtcyhyztmc;
    /**
     * @author <a href="mailto:huangyongkai@gtmap.cn">huangyongkai</a>
     * @description 脱敏
     */
    private String jtcymcTm;
    private String jtcyzjhTm;

    //共享标识	gxbs	字符串				1：共享，0：非共享
    private String gxbs;
    //唯一申报号
    private String wysbh;
    /**
     * ADD COLUMN `jtcyxb` VARCHAR(1) NULL COMMENT '家庭成员性别 字典表1：男2：女',
     */
    private String jtcyxb;
    /**
     * ADD COLUMN `jtcygjdm` VARCHAR(10) NULL COMMENT '家庭成员国籍代码 字典表GJ';
     */
    private String jtcygjdm;
    private String jtcygjmc;
    /**
     * 是否手动添加 0：否 1：是
     */
    private String sfsdtj;
    /**
     * 是否查询房产信息 0：否 1：是
     */
    private String sfcxfcxx;
    /**
     * 家庭成员房屋套次
     */
    private String jtcyfwtc;
    @Desensitized(type = SensitiveTypeEnum.MOBILE_PHONE, isEncrypter = true)
    private String jtcylxdh;
    private String jtcylxdhTm;

    public String getJtcylxdh() {
        return jtcylxdh;
    }

    public void setJtcylxdh(String jtcylxdh) {
        this.jtcylxdh = jtcylxdh;
    }

    public String getJtcylxdhTm() {
        return jtcylxdhTm;
    }

    public void setJtcylxdhTm(String jtcylxdhTm) {
        this.jtcylxdhTm = jtcylxdhTm;
    }

    public String getSfsdtj() {
        return sfsdtj;
    }

    public void setSfsdtj(String sfsdtj) {
        this.sfsdtj = sfsdtj;
    }

    public String getSfcxfcxx() {
        return sfcxfcxx;
    }

    public void setSfcxfcxx(String sfcxfcxx) {
        this.sfcxfcxx = sfcxfcxx;
    }

    public String getJtcyxb() {
        return jtcyxb;
    }

    public void setJtcyxb(String jtcyxb) {
        this.jtcyxb = jtcyxb;
    }

    public String getJtcygjdm() {
        return jtcygjdm;
    }

    public void setJtcygjdm(String jtcygjdm) {
        this.jtcygjdm = jtcygjdm;
    }

    public String getJtcygjmc() {
        return jtcygjmc;
    }

    public void setJtcygjmc(String jtcygjmc) {
        this.jtcygjmc = jtcygjmc;
    }

    public String getJtgxmc() {
        return jtgxmc;
    }

    public void setJtgxmc(String jtgxmc) {
        //登记3.0要赋null
        if (StringUtils.isBlank(jtgxmc)) {
            jtgxmc = null;
        }
        this.jtgxmc = jtgxmc;
    }

    public String getJtcyhyztmc() {
        return jtcyhyztmc;
    }

    public void setJtcyhyztmc(String jtcyhyztmc) {
        //登记3.0要赋null
        if (StringUtils.isBlank(jtcyhyztmc)) {
            jtcyhyztmc = null;
        }
        this.jtcyhyztmc = jtcyhyztmc;
    }

    public String getWysbh() {
        return wysbh;
    }

    public void setWysbh(String wysbh) {
        if (StringUtils.isBlank(wysbh)) {
            wysbh = null;
        }
        this.wysbh = wysbh;
    }

    public String getJtcyhyzt() {
        return jtcyhyzt;
    }

    public void setJtcyhyzt(String jtcyhyzt) {
        //登记3.0要赋null
        if (StringUtils.isBlank(jtcyhyzt)) {
            jtcyhyzt = null;
        }
        this.jtcyhyzt = jtcyhyzt;
    }

    public String getGxbs() {
        return gxbs;
    }

    public void setGxbs(String gxbs) {
        this.gxbs = gxbs;
    }

    public String getSqid() {
        return sqid;
    }

    public void setSqid(String sqid) {
        this.sqid = sqid;
    }

    public String getQlrid() {
        return qlrid;
    }

    public void setQlrid(String qlrid) {
        this.qlrid = qlrid;
    }

    public String getJtcymc() {
        return jtcymc;
    }

    public void setJtcymc(String jtcymc) {
        this.jtcymc = jtcymc;
    }

    public String getJtcyzjh() {
        return jtcyzjh;
    }

    public void setJtcyzjh(String jtcyzjh) {
        this.jtcyzjh = jtcyzjh;
    }

    public String getJtcyzjzl() {
        return jtcyzjzl;
    }

    public void setJtcyzjzl(String jtcyzjzl) {
        this.jtcyzjzl = jtcyzjzl;
    }

    public String getJtgx() {
        return jtgx;
    }

    public void setJtgx(String jtgx) {
        this.jtgx = jtgx;
    }

    public String getJtcymcTm() {
        return jtcymcTm;
    }

    public void setJtcymcTm(String jtcymcTm) {
        this.jtcymcTm = jtcymcTm;
    }

    public String getJtcyzjhTm() {
        return jtcyzjhTm;
    }

    public void setJtcyzjhTm(String jtcyzjhTm) {
        this.jtcyzjhTm = jtcyzjhTm;
    }

    public String getJtcyzjzlMc() {
        return jtcyzjzlMc;
    }

    public void setJtcyzjzlMc(String jtcyzjzlMc) {
        this.jtcyzjzlMc = jtcyzjzlMc;
    }

    public String getJtcyfwtc() {
        return jtcyfwtc;
    }

    public void setJtcyfwtc(String jtcyfwtc) {
        this.jtcyfwtc = jtcyfwtc;
    }
}
