package cn.gtmap.hlw.core.enums.status;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: 抵押状态标识 - 是否
 */
@Getter
@AllArgsConstructor
public enum DyStatusEnum {
    /**
     * 状态标识 - true
     */
    TRUE("0", "是", "抵押"),

    /**
     * 状态标识 - false
     */
    FALSE("1", "否", "无抵押");

    /**
     * 状态码
     */
    private String code;

    /**
     * 状态信息
     */
    private String msg;

    /**
     * 状态说明
     */
    private String explain;

    public static String getMsg(String code) {
        for (DyStatusEnum xq : DyStatusEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }

}
