package cn.gtmap.hlw.core.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/12/25
 * @description 任务状态枚举
 */
@Getter
@AllArgsConstructor
public enum RwztEnum {
    /**
     * 暂停
     */
    DDZT_STOP("0", "暂停"),
    /**
     * 启用
     */
    DDZT_START("1", "启用"),
    /**
     * 删除
     */
    DDZT_DELETE("2", "删除"),
    /**
     * 新增
     */
    DDZT_ADD("3", "新增");

    private String dm;
    private String mc;

    public static String getMcByDm (String dm) {
        if (StringUtils.isBlank(dm)) {
            return dm;
        }
        for (RwztEnum value : RwztEnum.values()) {
            if (dm.equals(value.getDm())) {
                return value.getMc();
            }
        }
        return "";
    }
}
