/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.string;

import com.alibaba.fastjson.JSON;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicUtil {
    private static final Logger log = LoggerFactory.getLogger(PublicUtil.class);

    public static <T> List<T> getBeanListByJsonArray(Object obj, Class<T> tClass) {
        List t = null;
        try {
            t = obj instanceof String ? JSON.parseArray((String)obj.toString(), tClass) : JSON.parseArray((String)JSON.toJSONString((Object)obj), tClass);
        }
        catch (Exception e) {
            log.error("getBeanListByJsonArray:" + e.getMessage());
        }
        return t;
    }

    public static <T> T getBeanByJsonObj(Object json, Class<T> tClass) {
        Object t = null;
        try {
            t = json instanceof String ? JSON.parseObject((String)json.toString(), tClass) : JSON.parseObject((String)JSON.toJSONString((Object)json), tClass);
        }
        catch (Exception e) {
            log.error("getBeanByJsonObj:" + e.getMessage());
        }
        return (T)t;
    }

    public static String getUserNameByLxdh(String lxdh) {
        String userName = null;
        if (StringUtils.isNotBlank((CharSequence)lxdh)) {
            userName = "yhm" + lxdh.substring(lxdh.length() - 4, lxdh.length()) + RandomStringUtils.randomNumeric((int)6);
        }
        return userName;
    }

    public static boolean compareString(String target, List<String> source) {
        if (StringUtils.isNotBlank((CharSequence)target) && source.size() > 0) {
            for (String compare : source) {
                if (!StringUtils.equals((CharSequence)compare, (CharSequence)target)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

