package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/7/12
 * @description 附件云签(GxYyFjYq)表实体类
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyFjYq implements Serializable {
    private static final long serialVersionUID = -4656644253877550528L;
    /**主键 */
    private String yqid;

    /**签署任务id*/
    private String qsrwid;

    /**受理编号*/
    private String slbh;

    /**申请ID*/
    private String sqid;

    /**附件id*/
    private String fjid;

    /**文件id*/
    private String docid;

    /**签署状态*/
    private String qszt;

    /**文件下载状态（1：未下载，2：已下载，3：下载失败）*/
    private String wjxzzt;

    /**备注*/
    private String bz;

    /**创建时间*/
    private Date cjsj;

    /**签署人ID（流程签署人的accountId，第三方返回）*/
    private String qsrid;

    /**修改时间*/
    private Date xgsj;

    /**签署url地址*/
    private String qsurl;

    /**权利人名称*/
    private String qlrmc;

    /**权利人证件号*/
    private String qlrzjh;

    /**签署人机构ID（一般是企业签署，机构账号Id，第三方返回）*/
    private String qsrjgid;

    /**是否取消（0否，1是)*/
    private String sfqx;

    /**签署类型（默认0：流程签署，1:税务签署（交易申报单：存量房买卖双方-商品房购房人），2：买卖双方签署）*/
    private String qslx;

    /**流水号*/
    private String lsh;

    /**签名图片路径*/
    private String imgpath;
}

