package cn.gtmap.hlw.core.model;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/*
 * @author <a href="mailto:zhangyu2@gtmap.cn">zhangyu2</a>
 * @version 1.0, 2017/1/18
 * @description 外网预约共享查询日志
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GxYyCheckRz implements Serializable {

    /**
     * 日志id
     */
    private String rzid;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 操作人id
     */
    private String czryid;

    /**
     * 操作时间
     * fastjson的注解,用于序列化时格式化date
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date czsj;

    /**
     * 操作人员名称
     */
    private String czrymc;


    /**
     * 限制信息入参Json
     */
    private String xzxxrcjson;

    /**
     * 限制信息反参Json
     */
    private String xzxxfcjson;
}
