package cn.gtmap.hlw.core.model.CrossRiver;


import cn.gtmap.hlw.core.annotation.Desensitized;
import cn.gtmap.hlw.core.enums.SensitiveTypeEnum;
import cn.gtmap.sdk.mybatis.plugin.annotation.Crypt;
import com.alibaba.fastjson.annotation.JSONField;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.Map;

/**
 * 不动产登记申请信息表，GX_YY_SQXX
 */
public class Sqxx {


    /**
     * 申请id
     */
    private String sqid;

    /**
     * 申请号
     */
    private String sqh;

    /**
     * 登记类型;字典项
     */
    private String djlx;

    /**
     * 申请登记类型;字典项 （组合登记存放小类）（多加的字段，非数据库字段）
     */
    private String sqdjlx;

    /**
     * 权利类型;字典项
     */
    private String qllx;

    /**
     * 共有方式;字典项
     */
    private String gyfs;

    /**
     * 共有方式;字典项 --抵押
     */
    private String gyfsDy;

    /**
     * 是否分别持证 0:否  1:是
     */
    private String sffbcz;

    /**
     * 不动产单元号
     */
    private String bdcdyh;

    /**
     * 交易价格
     */
    //@JSONField(serializeUsing = DoubleToStringSerializer.class)
    private Double jyjg;

    /**
     * 被担保主债权数额
     */
    //@JSONField(serializeUsing = DoubleToStringSerializer.class)
    private Double bdbzzqse;

    /**
     * 债务履行期限开始日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date zwlxqxksrq;

    /**
     * 债务履行期限结束日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date zwlxqxjsrq;

    /**
     * 评估价值
     */
    //@JSONField(serializeUsing = DoubleToStringSerializer.class)
    private Double pgjz;

    /**
     * 权利顺序
     */
    private String qlsx;

    /**
     * 抵押范围
     */
    private String dyfw;

    /**
     * 抵押方式
     */
    private String dyfs;

    /**
     * 抵押方式代码
     */
    private String dyfsdm;

    /**
     * 贷款方式
     */
    private String dkfs;

    /**
     * 原不动产权证证号
     */
    private String ybdcqzh;

    /**
     * 验证状态0:未验证或验证不过，1：验证通过
     */
    private Integer yzzt;

    /**
     * 导出状态，是否已导出。0：否；1：是
     */
    private Integer dczt;

    /**
     * 受理状态0：未受理；1：已受理
     */
    private Integer slzt;

    /**
     * 受理状态名称
     */
    private String slztMc;

    /**
     * 受理信息反馈信息也可以是验证的信息
     */
    private String slxx;

    /**
     * 备注
     */
    private String bz;

    /**
     * 创建用户
     */
    private String createUser;

    /**
     * 创建用户名称
     */
    private String createUserName;

    /**
     * 创建日期
     */
    private Date createDate;

    /**
     * 编辑日期
     */
    private Date editDate;

    /**
     * 坐落
     */
    @Desensitized(type = SensitiveTypeEnum.ADDRESS)
    private String zl;

    /**
     * 不动产价值
     */
    //@JSONField(serializeUsing = DoubleToStringSerializer.class)
    private Double bdcjz;

    /**
     * 抵押顺位
     */
    private Integer dysw;

    /**
     * 抵押顺位名称
     */
    private String dyswmc;

    /**
     * 登记类型名称
     */
    private String djlxmc;

    /**
     * 不动产登记证明号
     */
    private String dyzmh;

    /**
     * 申请证书版式 0:单一版， 1：集成版
     */
    private String sszsbs;

    /**
     * 不动产类型
     */
    private String bdclx;

    /**
     * 不动产类型代码（原来bdclx转换成名称给前台/applyModel/queryApplyListNotTm）
     */
    private String bdclxdm;

    /**
     * 面积
     */
    private Double mj;

    /**
     * 用途
     */
    private String yt;

    /**
     * 宗地/宗海权利性质
     */
    private String zdzhqlxz;

    /**
     * 构筑物类型
     */
    private String gzwlx;

    /**
     * 面积单位：平方米，亩， 公顷、万元。
     */
    private String mjdw;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 原受理编号
     */
    private String ySlbh;

    /**
     * 申请类型
     */
    private String sqlx;

    /**
     * 土地证号
     */
    private String tdzh;

    /**
     * 申请信息来源
     */
    private Integer sqxxly;

    /**
     * 创建用户id
     */
    private String createUserid;

    /**
     * 异议事项
     */
    private String yysx;


    /**
     * 所属用户类型（多加的字段，非数据库字段）
     */
    private String ssyhlx;


    /**
     * 总数（多加的字段，非数据库字段）
     */
    private String num;

    /**
     * 申请类型名称（多加的字段，非数据库字段）
     */
    private String sqlxmc;

    /**
     * 申请登记类型名称（多加的字段，非数据库字段）
     */
    private String sqdjlxmc;

    /**
     * 区域代码
     */
    private String qydm;

    /**
     * 登记中心
     */
    private String djzx;

    /**
     * 买卖合同编号
     */
    private String mmhth;

    /**
     * 备案合同号用于商品房，保存数据库后转换为mmhth
     */
    private String bahth;

    /**
     * 房产证号
     */
    private String fczh;

    /**
     * 是否邮寄--合肥使用
     */
    private String sfyj;

    /**
     * 邮寄地址--合肥使用
     */
    private String yjdz;

    /**
     * 是否组合
     */
    private String sfzh;

    /**
     * 合同签订日期
     */
    private String htqdrq;

    /**
     * 合同备案时间
     */
    private String barq;

    /**
     * 证书来源（2：新证书3：老证书）
     */
    private String zsly;

    /**
     * 不动产单元编号
     */
    private String bdcdybh;

    /**
     * 是否预约
     */
    private String sfyy;

    /**
     * (gx_yy_sqxx_hq)是否认证（0:是，1：否）
     */
    private String sfrz;

    /**
     * 是否查封
     */
    private String sfcf;

    /**
     * 是否抵押
     */
    private String sfdy;

    /**
     * 抵押银行代码
     */
    private String dyyhdm;

    /**
     * 抵押银行名称
     */
    private String dyyhmc;

    /**
     * 管理员审核人员gx_yy_user.USER_GUID
     */
    private String editUser;

    /**
     * 管理员审核人员gx_yy_user.UserName
     */
    private String editUserName;

    /**
     * 预约时间
     */
    private String yysj;

    /**
     * 审核备注
     */
    private String remark;

    /**
     * 登记中心名称
     */
    private String djzxmc;

    /**
     * 区域名称
     */
    private String qymc;

    /**
     * 不动产坐落是否验证Y：验证N：不验证
     */
    private String zlRequired;

    /**
     * 产权证号是否验证Y：验证N：不验证
     */
    private String fczhRequired;

    /**
     * 申请信息类型，sq：普通申请spwx：视频问询
     */
    private String sqxxlx;

    /**
     * 是否有中介信息 0 ：是  1： 否
     */
    private String sfczzjxx;

    /**
     * 新增契税满两年 0 未满两年 1 满两年 放代码
     */
    private String qsmln;

    /**
     * 视频问询相关字段
     * 声明人
     */
    private String smr;

    /**
     * 声明人身份证件号码
     */
    private String sfzjhm;

    /**
     * 视频问询原因（不能到场原因）
     */
    private String spwxyy;

    /**
     * 视频问询原因名称（不能到场原因）
     */
    private String spwxyymc;

    /**
     * 视频问询原因详情（不能到场原因）
     */
    private String spwxyyxq;

    /**
     * 脱敏数据，坐落
     */
    private String zlTm;

    /**
     * 创建人所属部门orgId
     */
    private String createOrgId;
    /**
     * 创建部门名称
     */
    private String cjbmmc;

    /**
     * 操作人所属部门id
     */
    private String updateOrgId;

    /**
     * 审核部门ID
     */
    private String shOrgId;

    /**
     * 权利人名称，以逗号隔开
     */
    @Crypt(versions = "v1.0", separator = ",")
    private String qlrmc;

    /**
     * 权利人证件号，以逗号隔开
     */
    private String qlrzjh;

    /**
     * 义务人名称,以逗号隔开
     */
    @Crypt(versions = "v1.0", separator = ",")
    private String ywrmc;

    /**
     * 义务人证件号,以逗号隔开
     */
    private String ywrzjh;

    /**
     * 房产证号list（分别持证时，以逗号隔开）
     */
    private String fczhList;

    /**
     * 税款减免（0 否 1 是 ）
     */
    private String skjm;

    /**
     * 项目id
     */
    private String xmid;

    /**
     * 用于获取宗地用途，面积的zsxmid
     */
    private String zsxmid;

    /**
     * 是否抵押流程
     */
    private String sfdylc;

    /**
     * 与交易接口 首付款
     */
    private Double sfk;

    /**
     * 贷款金额
     */
    private Double dkje;

    /**
     * 付款方式代码
     */
    private String fkfs;
    /**
     * 付款方式名称
     */
    private String fkfsMc;

    /**
     * 登记原因代码
     */
    private String djyy;

    /**
     * 登记原因名称,用于展示
     */
    private String djyyMc;

    /**
     * 是否需要预审
     */
    private String sfxyys;

    /**
     * 业务系统受理编号（业务系统返回值）
     */
    private String ywxtslbh;

    /**
     * 预告证明
     */
    private String ygzm;

    /**
     * 预告抵押证明
     */
    private String ygdyzm;

    /**
     * 是否资金监管
     */
    private String sfzjjg;

    /**
     * 税务状态（0：无需纳税，1：未核税，2：已核税，3：已缴税）
     */
    private String swzt;

    /**
     * 税务审核信息
     */
    private String swshxx;

    /**
     * 税务状态名称（0：无需纳税，1：未核税，2：已核税，3：已缴税）
     */
    private String swztMc;

    /**
     * 房源编号
     */
    private String fybh;

    /**
     * 合同状态htzt  0 是 已网签 传代码 非申请信息字段
     */
    private String htzt;

    /**
     * 缴费状态（0:未缴费 1:部分缴费 2:已缴费）
     */
    private String jfzt;

    /**
     * 缴费状态吗名称
     */
    private String jfztMc;

    /**
     * 预审通过时间
     */
    private Date yytgsj;

    /**
     * 预审提示信息
     */
    private String ystsxx;

    /**
     * 取得价格
     */
    private Double qdjg;

    /**
     * 查封类型--子类型代码
     */
    private String zlxdm;

    /**
     * 查封类型--子类型名称
     */
    private String zlxmc;

    /**
     * 用途代码--流程重新申请，用来存放ytdm字段
     */
    private String ytdm;

    /**
     * 权利类型代码--流程重新申请，用来存放qllxdm字段
     */
    private String qllxdm;

    /**
     * 业务号，用来存储合同信息接口返回的业务号
     */
    private String ywh;

    /**
     * 房产类型(0住宅，1非住宅
     */
    private String fclx;

    /**
     * slbh反序，冗余字段（预审模糊查询）
     */
    private String slbhReverse;

    /**
     * 登记时间（泰兴使用）
     */
    private String djsj;

    /**
     * 购房发票号码
     */
    private String gffphm;

    /**
     * 购房发票代码
     */
    private String gffpdm;

    /**
     * 债务人
     */
    private String zwr;

    /**
     * 抵押面积
     */
    private String dymj;

    /**
     * 抵押面积其中土地
     */
    private String dymjqztd;

    /**
     * 抵押物价值
     */
    private String dywjz;

    /**
     * 被担保债权数额其中土地
     */
    private String bdbzzqseqztd;

    /**
     * 抵押物价值其中土地
     */
    private String dywjzqztd;

    /**
     * 最高债权确定事实
     */
    private String zgzqqdss;

    /**
     * 最高债权确定事实名称
     */
    private String zgzqqdssmc;

    /**
     * 附记
     */
    private String fj;

    /**
     * 宗地宗海权利性质名称 新增字段（非数据库字段）
     */
    private String zdzhqlxzmc;

    /**
     * 房间id
     */
    private String roomid;

    /**
     * 会签方式（0三方会签，1开发商待办）
     */
    private String hqfs;

    /**
     * 税务部门预审orgid
     */
    private String swOrgid;

    /**
     * 土地抵押面积
     */
    private String tddymj;

    /**
     * 房屋抵押面积
     */
    private String fwdymj;

    /**
     * 权证印刷序列号（印制号）
     */
    private String qzysxlh;

    /**
     * 是否显示预约
     */
    private String sfxsyy;

    /**
     * 证书id（南通套打印制号,自动办结使用）
     */
    private String zsid;

    /**
     * 是否办理遗失公告1:是，0：否'
     */
    private String sfblysgg;

    /**
     * 交易uuid
     */
    private String jyid;

    /**
     * 登记系统创建时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date djxtcjsj;

    /**
     * 申请事由
     */
    private String sqsy;

    /**
     * 申请事由名称
     */
    private String sqsymc;

    /**
     * 退件原因
     */
    private String tjyy;

    /**
     * 是否主房
     */
    private String sfzf;

    /**
     * 是否组合贷款(0否 ， 1是)
     */
    private String sfzhdk;

    /**
     * 税费承担(字典项)
     */
    private String sfcd;

    /**
     * 税费承担名称
     */
    private String sfcdmc;

    /**
     * 争议解决方式(字典项)
     */
    private String zyjjfs;

    /**
     * 争议解决方式名称
     */
    private String zyjjfsmc;

    /**
     * 抵押贷款类别（字典项）
     */
    private String dydklb;

    /**
     * 抵押贷款类别名称
     */
    private String dydklbmc;

    /**
     * 权利设定方式
     */
    private String qlsdfs;

    /**
     * 权利设定方式名称
     */
    private String qlsdfsmc;

    /**
     * 被执行人信息查询描述
     */
    private String bzxrxxcxms;

    /**
     * 查询结果说明
     */
    private String cxjgsm;
    /**
     * 云签状态(1：未签署，2：已签署或者免签署）
     */
    private String yqzt;

    /**
     * 业务小类（代码）
     */
    private String ywxl;

    /**
     * 业务小类（名称）
     */
    private String ywxlmc;

    /**
     * 取得方式（代码）
     */
    private String dqfs;

    /**
     * 取得方式（名称）
     */
    private String qdfsmc;

    /**
     * 证书形式代码（1：纸质证2：电子证）
     */
    private String zsxsdm;

    /**
     * 是否存在约定(0:否 1:是)
     */
    private String sfczyd;

    /**
     * 担保范围
     */
    private String dbfw;

    /**
     * (推送设置)登记子项代码
     */
    private String tsszDjzxdm;

    /**
     * (推送设置)登记子项名称
     */
    private String tsszDjzxmc;

    /**
     * 房屋ID(房屋编号,税务返回)
     */
    private String fwuuid;

    /**
     * 权籍关联代码(字典项QJGL)
     */
    private String qjgldm;

    /**
     * 权籍关联名称(字典项QJGL)
     */
    private String qjglmc;

    /**
     * 使用期限
     */
    private String syqx;

    /**
     * 产权来源
     */
    private String cqly;

    /**
     * 申请按份共有的权利人处分方式（0:经占份额三分之二以上的共有人同意,1: 全体共同共有人同意,放代码）
     */
    private String cffs;

    /**
     * 登记接收人名称
     */
    private String djjsrmc;

    /**
     * 登记接收人ID
     */
    private String djjsrid;

    /**
     * 一卡清状态（YKQZT字典）
     */
    private String ykqzt;

    /**
     * 缴库状态(0:未缴库，1:已缴库)
     */
    private String jkzt;

    /**
     * 企业备案编号
     */
    private String qybabh;

    /**
     * 申请书内容
     */
    private String sqsnr;

    /**
     * 水电气过户id
     */
    private String sdqghid;

    /**
     * 是否已领取纸质登记证明
     */
    private String sfylqzzdjzm;

    private Map sqsnrMap;
    /**
     * 登记事由
     */
    private String djsy;

    /**
     * 准销证号
     */
    private String zxzh;

    /**
     * 是否完全开发
     */
    private String sfwqkf;
    /**
     * 更正登记类型代码
     */
    private String gzdjlxdm;
    /**
     * 更正主体
     */
    private String gzzt;
    /**
     * 更正依据
     */
    private String gzyj;
    /**
     * 更正内容
     */
    private String gznr;
    /**
     * 更正登记类型名称
     */
    private String gzdjlxmc;

    /**
     * 申请材料提交方式
     */
    private String sqcltjfs;

    /**
     * 项目子编号
     */
    private String xmzbh;

    /**
     * 缴费状态时间
     */
    private Date jfztsj;

    /**
     * 水电气操作人
     */
    private String sdqczr;

    /**
     * 不处理原因
     */
    private String bclyy;

    /**
     * 监证机关
     */
    private String jzjg;
    /**
     * 违约责任
     */
    private String wyzr;
    /**
     * 查询目的
     */
    private String cxmd;
    /**
     * sfzdcj varchar(2) default '' null comment '是否自动创建 1：是，0：否',
     */
    private String sfzdcj;
    /**
     * sfyhzl varchar(2) default '' null comment '是否银行直连1：是，0：否',
     */
    private String sfyhzl;
    /**
     * sqdwwybs varchar(50) default '' comment '申请单位唯一标识(代码)',
     */
    private String sqdwwybs;
    /**
     * sftzzs varchar(2) default '' comment '是否台账展示，1：是（单个、批量第一个），0：否 2转移 3抵押';
     */
    private String sftzzs;
    /**
     * `jkfs` VARCHAR(100) NULL COMMENT '缴款方式 0：不交税费1：税费同缴';
     */
    private String jkfs;
    /**
     * 数据来源(1:微信 2:网页 3:APP)入参head.origin
     */
    private String sjly;

    /**
     * 缴费方式 （1:线上缴费 2:窗口缴费)
     */
    private String jffs;
    /**
     * 缴费方式名称（非数据库字段）
     */
    private String jffsmc;
    /**
     * sfsftg varchar(2) COMMENT '是否税费托管（0否，1是)'
     */
    private String sfsftg;
    /**
     * dsffwsjsj VARCHAR(25) COMMENT '第三方服务收件时间（示例：2022-12-11 21:12:33），存的第三方的收件时间'
     */
    private String dsffwsjsj;

    /**
     * '是否需要登簿发证 （0：否，1：是）';
     */
    private String sfxydbfz;

    /**
     * 公告类型
     */
    private String gglx;

    /**
     * 公告类型名称
     */
    private String gglxmc;

    /**
     * 发布单位
     */
    private String fbdw;

    /**
     * 发布单位名称
     */
    private String fbdwmc;

    /**
     * 登记证书形式代码（1：纸质证 2：电子证）
     */
    private String djzsxsdm;

    /**
     * 预审地区代码
     */
    private String ysdqdm;

    /**
     * 预审地区名称
     */
    private String ysdqmc;

    /**
     * 集成化办公登记回调标识
     */
    private String djhdbs;

    /**
     * 集成化办公税务回调标识
     */
    private String swhdbs;

    /**
     * 是否推送预审 1：是，0：否
     */
    private String sftsys;

    /**
     * 拆迁单位
     */
    private String cqdw;

    /**
     * 是否原抵押（0：否，1：是）
     */
    private String sfydy;

    /**
     * 是否线下办理（1：是，0：否）
     */
    private String sfxxbl;

    /**
     * 是否完成视频公证（1：是，0：否）
     */
    private String sfwcspgz;

    /**
     * 是否抵押注销（0：否，1：是）
     */
    private String sfdyzx;

    /**
     * 抵押状态(gx_yy_sqxx中的sfdy)
     */
    private String dyzt;
    /**
     * 完税时间
     */
    private String wssj;
    /**
     * 核税时间
     */
    private String hssj;
    /**
     * 是否已纳税 1：已纳税，0：未纳税
     */
    private String sfyns;
    /**
     * 是否代办标识1:是 0:否
     */
    private String sfdb;
    /**
     * 应纳税额合计
     */
    private Double ynsehj;
    /**
     * 是否跨行抵押1:是 0:否
     */
    private String sfkhdy;

    /**
     * 是否推送交易（0：否，1：是）
     */
    private String sftsjy;

    /**
     * 登记是否自动转发向审核节点 0不转发 1转发
     */
    private String djsfzdzf;
    /**
     * 是否一次收费(1：是，0：否)
     */
    private String sfycjf;

    /**
     * 是否整体发证(0：否，1：是)
     */
    private String sfztfz;
    /**
     * 智慧中枢受理编号
     */
    private String zhzsslbh;
    /**
     * 提交预审时间
     */
    private Date tjyssj;
    /**
     * 贷款情况（0未实际发放 1已全部结清）
     */
    private String dkqk;
    /**
     * 是否打印纸质证明（0未领取 1已不慎遗失）
     */
    private String sfdyzzzm;

    /**
     * 查询案号
     */
    private String cxah;


    private String cxnr;

    private String cxjgyq;

    private String lhgxyy;

    private String cxmdst;
    /**
     * 是否交地即发证（0：否，1：是）
     */
    private String sfjdjfz;

    /**
     * 是否提供现场服务（0：否，1：是）
     */
    private String sftgxcfw;

    /**
     * 是否无还本续贷（0：否，1：是）
     */
    private String sfwhbxd;

    /**
     * 遗失产权证号（0：否，1：是）
     */
    private String yscqzh;

    /**
     * 是否带押过户（0：否，1：是）
     */
    private String sfdygh;
    /**
     *  是否竣备即发证（0：否，1：是）
     */
    private String sfjbjfz;
    /**
     * 竣工验收备案日期
     */
    private String jgysbarq;
    /**
     * 抵押证明号 盐城99904108/99904149业务创建推送用
     */
    private String zmxmid;
    /**
     * 抵押注销证明申请人
     */
    private String dyzxzmsqr;
    /**
     * 抵押注销证明申请人证件号
     */
    private String dyzxzmsqrzjh;

    public String getSfjbjfz() {
        return sfjbjfz;
    }

    public void setSfjbjfz(String sfjbjfz) {
        this.sfjbjfz = sfjbjfz;
    }

    public String getJgysbarq() {
        return jgysbarq;
    }

    public void setJgysbarq(String jgysbarq) {
        this.jgysbarq = jgysbarq;
    }

    public String getZhzsslbh() {
        return zhzsslbh;
    }

    public void setZhzsslbh(String zhzsslbh) {
        this.zhzsslbh = zhzsslbh;
    }

    public String getSfztfz() {
        return sfztfz;
    }

    public void setSfztfz(String sfztfz) {
        this.sfztfz = sfztfz;
    }

    public String getSfycjf() {
        return sfycjf;
    }

    public void setSfycjf(String sfycjf) {
        this.sfycjf = sfycjf;
    }

    public Double getYnsehj() {
        return ynsehj;
    }

    public void setYnsehj(Double ynsehj) {
        this.ynsehj = ynsehj;
    }

    public String getCjbmmc() {
        return cjbmmc;
    }

    public void setCjbmmc(String cjbmmc) {
        this.cjbmmc = cjbmmc;
    }

    public String getSfxydbfz() {
        return sfxydbfz;
    }

    public void setSfxydbfz(String sfxydbfz) {
        this.sfxydbfz = sfxydbfz;
    }

    public String getSfsftg() {
        return sfsftg;
    }

    public void setSfsftg(String sfsftg) {
        this.sfsftg = sfsftg;
    }

    public String getJffs() {
        return jffs;
    }

    public void setJffs(String jffs) {
        this.jffs = jffs;
    }

    public String getJffsmc() {
        return jffsmc;
    }

    public void setJffsmc(String jffsmc) {
        this.jffsmc = jffsmc;
    }

    public String getSjly() {
        return sjly;
    }

    public void setSjly(String sjly) {
        this.sjly = sjly;
    }

    public String getJkfs() {
        return jkfs;
    }

    public void setJkfs(String jkfs) {
        this.jkfs = jkfs;
    }

    public String getSfzdcj() {
        return sfzdcj;
    }

    public void setSfzdcj(String sfzdcj) {
        this.sfzdcj = sfzdcj;
    }

    public String getSfyhzl() {
        return sfyhzl;
    }

    public void setSfyhzl(String sfyhzl) {
        this.sfyhzl = sfyhzl;
    }

    public String getSqdwwybs() {
        return sqdwwybs;
    }

    public void setSqdwwybs(String sqdwwybs) {
        this.sqdwwybs = sqdwwybs;
    }

    public String getSftzzs() {
        return sftzzs;
    }

    public void setSftzzs(String sftzzs) {
        this.sftzzs = sftzzs;
    }

    public String getJzjg() {
        return jzjg;
    }

    public void setJzjg(String jzjg) {
        this.jzjg = jzjg;
    }

    public String getWyzr() {
        return wyzr;
    }

    public void setWyzr(String wyzr) {
        this.wyzr = wyzr;
    }

    public String getXmzbh() {
        return xmzbh;
    }

    public void setXmzbh(String xmzbh) {
        this.xmzbh = xmzbh;
    }

    public String getSqcltjfs() {
        return sqcltjfs;
    }

    public void setSqcltjfs(String sqcltjfs) {
        this.sqcltjfs = sqcltjfs;
    }

    public String getGzdjlxdm() {
        return gzdjlxdm;
    }

    public void setGzdjlxdm(String gzdjlxdm) {
        this.gzdjlxdm = gzdjlxdm;
    }

    public String getGzzt() {
        return gzzt;
    }

    public void setGzzt(String gzzt) {
        this.gzzt = gzzt;
    }

    public String getGzyj() {
        return gzyj;
    }

    public void setGzyj(String gzyj) {
        this.gzyj = gzyj;
    }

    public String getGznr() {
        return gznr;
    }

    public void setGznr(String gznr) {
        this.gznr = gznr;
    }

    public String getGzdjlxmc() {
        return gzdjlxmc;
    }

    public void setGzdjlxmc(String gzdjlxmc) {
        this.gzdjlxmc = gzdjlxmc;
    }

    public String getSfwqkf() {
        return sfwqkf;
    }

    public void setSfwqkf(String sfwqkf) {
        this.sfwqkf = sfwqkf;
    }

    public String getZxzh() {
        return zxzh;
    }

    public void setZxzh(String zxzh) {
        this.zxzh = zxzh;
    }

    public String getDjsy() {
        return djsy;
    }

    public void setDjsy(String djsy) {
        this.djsy = djsy;
    }

    public Map getSqsnrMap() {
        return sqsnrMap;
    }

    public void setSqsnrMap(Map sqsnrMap) {
        this.sqsnrMap = sqsnrMap;
    }

    public String getSqsnr() {
        return sqsnr;
    }

    public void setSqsnr(String sqsnr) {
        this.sqsnr = sqsnr;
    }

    public String getQybabh() {
        return qybabh;
    }

    public void setQybabh(String qybabh) {
        this.qybabh = qybabh;
    }

    public String getJkzt() {
        return jkzt;
    }

    public void setJkzt(String jkzt) {
        this.jkzt = jkzt;
    }

    public String getYkqzt() {
        return ykqzt;
    }

    public void setYkqzt(String ykqzt) {
        this.ykqzt = ykqzt;
    }

    public String getDjjsrmc() {
        return djjsrmc;
    }

    public void setDjjsrmc(String djjsrmc) {
        this.djjsrmc = djjsrmc;
    }

    public String getDjjsrid() {
        return djjsrid;
    }

    public void setDjjsrid(String djjsrid) {
        this.djjsrid = djjsrid;
    }

    public String getQjgldm() {
        return qjgldm;
    }

    public void setQjgldm(String qjgldm) {
        this.qjgldm = qjgldm;
    }

    public String getQjglmc() {
        return qjglmc;
    }

    public void setQjglmc(String qjglmc) {
        this.qjglmc = qjglmc;
    }

    public String getFwuuid() {
        return fwuuid;
    }

    public void setFwuuid(String fwuuid) {
        this.fwuuid = fwuuid;
    }

    public String getZsxsdm() {
        return zsxsdm;
    }

    public void setZsxsdm(String zsxsdm) {
        this.zsxsdm = zsxsdm;
    }

    public String getSfczyd() {
        return sfczyd;
    }

    public void setSfczyd(String sfczyd) {
        this.sfczyd = sfczyd;
    }

    public String getDbfw() {
        return dbfw;
    }

    public void setDbfw(String dbfw) {
        this.dbfw = dbfw;
    }

    public String getYwxlmc() {
        return ywxlmc;
    }

    public void setYwxlmc(String ywxlmc) {
        this.ywxlmc = ywxlmc;
    }

    public String getDqfs() {
        return dqfs;
    }

    public void setDqfs(String dqfs) {
        this.dqfs = dqfs;
    }

    public String getQdfsmc() {
        return qdfsmc;
    }

    public void setQdfsmc(String qdfsmc) {
        this.qdfsmc = qdfsmc;
    }

    public String getYwxl() {
        return ywxl;
    }

    public void setYwxl(String ywxl) {
        this.ywxl = ywxl;
    }

    public String getYqzt() {
        return yqzt;
    }

    public void setYqzt(String yqzt) {
        this.yqzt = yqzt;
    }

    public String getBdclxdm() {
        return bdclxdm;
    }

    public void setBdclxdm(String bdclxdm) {
        this.bdclxdm = bdclxdm;
    }

    public String getTjyy() {
        return tjyy;
    }

    public void setTjyy(String tjyy) {
        this.tjyy = tjyy;
    }

    public Date getDjxtcjsj() {
        return djxtcjsj;
    }

    public void setDjxtcjsj(Date djxtcjsj) {
        this.djxtcjsj = djxtcjsj;
    }

    public String getJyid() {
        return jyid;
    }

    public void setJyid(String jyid) {
        this.jyid = jyid;
    }

    public String getSwOrgid() {
        return swOrgid;
    }

    public void setSwOrgid(String swOrgid) {
        this.swOrgid = swOrgid;
    }

    public String getHqfs() {
        return hqfs;
    }

    public void setHqfs(String hqfs) {
        this.hqfs = hqfs;
    }

    public String getRoomid() {
        return roomid;
    }

    public void setRoomid(String roomid) {
        this.roomid = roomid;
    }

    public String getZdzhqlxzmc() {
        return zdzhqlxzmc;
    }

    public void setZdzhqlxzmc(String zdzhqlxzmc) {
        this.zdzhqlxzmc = zdzhqlxzmc;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    public String getZwr() {
        return zwr;
    }

    public void setZwr(String zwr) {
        this.zwr = zwr;
    }

    public String getDymj() {
        return dymj;
    }

    public void setDymj(String dymj) {
        this.dymj = dymj;
    }

    public String getDymjqztd() {
        return dymjqztd;
    }

    public void setDymjqztd(String dymjqztd) {
        this.dymjqztd = dymjqztd;
    }

    public String getDywjz() {
        return dywjz;
    }

    public void setDywjz(String dywjz) {
        this.dywjz = dywjz;
    }

    public String getBdbzzqseqztd() {
        return bdbzzqseqztd;
    }

    public void setBdbzzqseqztd(String bdbzzqseqztd) {
        this.bdbzzqseqztd = bdbzzqseqztd;
    }

    public String getDywjzqztd() {
        return dywjzqztd;
    }

    public void setDywjzqztd(String dywjzqztd) {
        this.dywjzqztd = dywjzqztd;
    }

    public String getGffphm() {
        return gffphm;
    }

    public void setGffphm(String gffphm) {
        this.gffphm = gffphm;
    }

    public String getGffpdm() {
        return gffpdm;
    }

    public void setGffpdm(String gffpdm) {
        this.gffpdm = gffpdm;
    }

    public String getDjsj() {
        return djsj;
    }

    public void setDjsj(String djsj) {
        this.djsj = djsj;
    }

    public String getSwshxx() {
        return swshxx;
    }

    public void setSwshxx(String swshxx) {
        this.swshxx = swshxx;
    }

    public String getFclx() {
        return fclx;
    }

    public void setFclx(String fclx) {
        this.fclx = fclx;
    }

    public String getShOrgId() {
        return shOrgId;
    }

    public void setShOrgId(String shOrgId) {
        this.shOrgId = shOrgId;
    }

    public String getDyfsdm() {
        return dyfsdm;
    }

    public void setDyfsdm(String dyfsdm) {
        this.dyfsdm = dyfsdm;
    }

    public String getJfztMc() {
        return jfztMc;
    }

    public void setJfztMc(String jfztMc) {
        this.jfztMc = jfztMc;
    }

    public Date getYytgsj() {
        return yytgsj;
    }

    public void setYytgsj(Date yytgsj) {
        this.yytgsj = yytgsj;
    }

    public String getYstsxx() {
        return ystsxx;
    }

    public void setYstsxx(String ystsxx) {
        this.ystsxx = ystsxx;
    }

    public String getHtzt() {
        return htzt;
    }

    public void setHtzt(String htzt) {
        this.htzt = htzt;
    }

    public String getZsxmid() {
        return zsxmid;
    }

    public void setZsxmid(String zsxmid) {
        this.zsxmid = zsxmid;
    }

    public String getSfxyys() {
        return sfxyys;
    }

    public void setSfxyys(String sfxyys) {
        this.sfxyys = sfxyys;
    }

    public String getSlztMc() {
        return slztMc;
    }

    public void setSlztMc(String slztMc) {
        this.slztMc = slztMc;
    }

    public String getFkfs() {
        return fkfs;
    }

    public void setFkfs(String fkfs) {
        this.fkfs = fkfs;
    }

    public String getFkfsMc() {
        return fkfsMc;
    }

    public void setFkfsMc(String fkfsMc) {
        this.fkfsMc = fkfsMc;
    }

    public String getDjyy() {
        return djyy;
    }

    public void setDjyy(String djyy) {
        this.djyy = djyy;
    }

    public Double getSfk() {
        return sfk;
    }

    public void setSfk(Double sfk) {
        this.sfk = sfk;
    }

    public Double getDkje() {
        return dkje;
    }

    public void setDkje(Double dkje) {
        this.dkje = dkje;
    }

    public String getSfdylc() {
        return sfdylc;
    }

    public void setSfdylc(String sfdylc) {
        this.sfdylc = sfdylc;
    }

    public String getSqid() {
        return sqid;
    }

    public void setSqid(String sqid) {
        this.sqid = sqid;
    }

    public String getSqh() {
        return sqh;
    }

    public void setSqh(String sqh) {
        this.sqh = sqh;
    }

    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    public String getSqdjlx() {
        return sqdjlx;
    }

    public void setSqdjlx(String sqdjlx) {
        this.sqdjlx = sqdjlx;
    }

    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    public String getGyfs() {
        return gyfs;
    }

    public void setGyfs(String gyfs) {
        this.gyfs = gyfs;
    }

    public String getGyfsDy() {
        return gyfsDy;
    }

    public void setGyfsDy(String gyfsDy) {
        this.gyfsDy = gyfsDy;
    }

    public String getSffbcz() {
        return sffbcz;
    }

    public void setSffbcz(String sffbcz) {
        this.sffbcz = sffbcz;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public Double getJyjg() {
        return jyjg;
    }

    public void setJyjg(Double jyjg) {
        this.jyjg = jyjg;
    }

    public Double getBdbzzqse() {
        return bdbzzqse;
    }

    public void setBdbzzqse(Double bdbzzqse) {
        this.bdbzzqse = bdbzzqse;
    }

    public Date getZwlxqxksrq() {
        return zwlxqxksrq;
    }

    public void setZwlxqxksrq(Date zwlxqxksrq) {
        this.zwlxqxksrq = zwlxqxksrq;
    }

    public Date getZwlxqxjsrq() {
        return zwlxqxjsrq;
    }

    public void setZwlxqxjsrq(Date zwlxqxjsrq) {
        this.zwlxqxjsrq = zwlxqxjsrq;
    }

    public Double getPgjz() {
        return pgjz;
    }

    public void setPgjz(Double pgjz) {
        this.pgjz = pgjz;
    }

    public String getDyfw() {
        return dyfw;
    }

    public void setDyfw(String dyfw) {
        this.dyfw = dyfw;
    }

    public String getDyfs() {
        return dyfs;
    }

    public void setDyfs(String dyfs) {
        this.dyfs = dyfs;
    }

    public String getDkfs() {
        return dkfs;
    }

    public void setDkfs(String dkfs) {
        this.dkfs = dkfs;
    }

    public String getYbdcqzh() {
        return ybdcqzh;
    }

    public void setYbdcqzh(String ybdcqzh) {
        this.ybdcqzh = ybdcqzh;
    }

    public String getSlxx() {
        return slxx;
    }

    public void setSlxx(String slxx) {
        this.slxx = slxx;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getEditDate() {
        return editDate;
    }

    public void setEditDate(Date editDate) {
        this.editDate = editDate;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public Double getBdcjz() {
        return bdcjz;
    }

    public void setBdcjz(Double bdcjz) {
        this.bdcjz = bdcjz;
    }

    public Integer getDysw() {
        return dysw;
    }

    public void setDysw(Integer dysw) {
        this.dysw = dysw;
    }

    public String getDyswmc() {
        return dyswmc;
    }

    public void setDyswmc(String dyswmc) {
        this.dyswmc = dyswmc;
    }

    public String getDjlxmc() {
        return djlxmc;
    }

    public void setDjlxmc(String djlxmc) {
        this.djlxmc = djlxmc;
    }

    public String getDyzmh() {
        return dyzmh;
    }

    public void setDyzmh(String dyzmh) {
        this.dyzmh = dyzmh;
    }

    public String getSszsbs() {
        return sszsbs;
    }

    public void setSszsbs(String sszsbs) {
        this.sszsbs = sszsbs;
    }

    public String getBdclx() {
        return bdclx;
    }

    public void setBdclx(String bdclx) {
        this.bdclx = bdclx;
    }

    public Double getMj() {
        return mj;
    }

    public void setMj(Double mj) {
        this.mj = mj;
    }

    public String getYt() {
        return yt;
    }

    public void setYt(String yt) {
        this.yt = yt;
    }

    public String getZdzhqlxz() {
        return zdzhqlxz;
    }

    public void setZdzhqlxz(String zdzhqlxz) {
        this.zdzhqlxz = zdzhqlxz;
    }

    public String getGzwlx() {
        return gzwlx;
    }

    public void setGzwlx(String gzwlx) {
        this.gzwlx = gzwlx;
    }

    public String getMjdw() {
        return mjdw;
    }

    public void setMjdw(String mjdw) {
        this.mjdw = mjdw;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
        //冗余字段
        StringBuffer buffer = new StringBuffer();
        buffer.append(slbh);
        this.setSlbhReverse(buffer.reverse().toString());
    }

    public Integer getYzzt() {
        return yzzt;
    }

    public void setYzzt(Integer yzzt) {
        this.yzzt = yzzt;
    }

    public Integer getDczt() {
        return dczt;
    }

    public void setDczt(Integer dczt) {
        this.dczt = dczt;
    }

    public Integer getSlzt() {
        return slzt;
    }

    public void setSlzt(Integer slzt) {
        this.slzt = slzt;
    }

    public Integer getSqxxly() {
        return sqxxly;
    }

    public void setSqxxly(Integer sqxxly) {
        this.sqxxly = sqxxly;
    }

    public String getSqlx() {
        return sqlx;
    }

    public void setSqlx(String sqlx) {
        this.sqlx = sqlx;
    }

    public String getTdzh() {
        return tdzh;
    }

    public void setTdzh(String tdzh) {
        this.tdzh = tdzh;
    }

    public String getCreateUserid() {
        return createUserid;
    }

    public void setCreateUserid(String createUserid) {
        this.createUserid = createUserid;
    }

    public String getYysx() {
        return yysx;
    }

    public void setYysx(String yysx) {
        this.yysx = yysx;
    }

    public String getSsyhlx() {
        return ssyhlx;
    }

    public void setSsyhlx(String ssyhlx) {
        this.ssyhlx = ssyhlx;
    }

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getSqlxmc() {
        return sqlxmc;
    }

    public void setSqlxmc(String sqlxmc) {
        this.sqlxmc = sqlxmc;
    }

    public String getSqdjlxmc() {
        return sqdjlxmc;
    }

    public void setSqdjlxmc(String sqdjlxmc) {
        this.sqdjlxmc = sqdjlxmc;
    }

    public String getQydm() {
        return qydm;
    }

    public void setQydm(String qydm) {
        this.qydm = qydm;
    }

    public String getDjzx() {
        return djzx;
    }

    public void setDjzx(String djzx) {
        this.djzx = djzx;
    }

    public String getMmhth() {
        return mmhth;
    }

    public void setMmhth(String mmhth) {
        this.mmhth = mmhth;
    }

    public String getBahth() {
        return bahth;
    }

    public void setBahth(String bahth) {
        this.bahth = bahth;
    }

    public String getFczh() {
        return fczh;
    }

    public void setFczh(String fczh) {
        this.fczh = fczh;
    }

    public String getSfyj() {
        return sfyj;
    }

    public void setSfyj(String sfyj) {
        this.sfyj = sfyj;
    }

    public String getYjdz() {
        return yjdz;
    }

    public void setYjdz(String yjdz) {
        this.yjdz = yjdz;
    }

    public String getSfzh() {
        return sfzh;
    }

    public void setSfzh(String sfzh) {
        this.sfzh = sfzh;
    }

    public String getHtqdrq() {
        return htqdrq;
    }

    public void setHtqdrq(String htqdrq) {
        this.htqdrq = htqdrq;
    }

    public String getBarq() {
        return barq;
    }

    public void setBarq(String barq) {
        this.barq = barq;
    }

    public String getZsly() {
        return zsly;
    }

    public void setZsly(String zsly) {
        this.zsly = zsly;
    }

    public String getBdcdybh() {
        return bdcdybh;
    }

    public void setBdcdybh(String bdcdybh) {
        this.bdcdybh = bdcdybh;
    }

    public String getSfyy() {
        return sfyy;
    }

    public void setSfyy(String sfyy) {
        this.sfyy = sfyy;
    }

    public String getSfrz() {
        return sfrz;
    }

    public void setSfrz(String sfrz) {
        this.sfrz = sfrz;
    }

    public String getSfcf() {
        return sfcf;
    }

    public void setSfcf(String sfcf) {
        this.sfcf = sfcf;
    }

    public String getSfdy() {
        return sfdy;
    }

    public void setSfdy(String sfdy) {
        this.sfdy = sfdy;
    }

    public String getDyyhdm() {
        return dyyhdm;
    }

    public void setDyyhdm(String dyyhdm) {
        this.dyyhdm = dyyhdm;
    }

    public String getDyyhmc() {
        return dyyhmc;
    }

    public void setDyyhmc(String dyyhmc) {
        this.dyyhmc = dyyhmc;
    }

    public String getEditUser() {
        return editUser;
    }

    public void setEditUser(String editUser) {
        this.editUser = editUser;
    }

    public String getEditUserName() {
        return editUserName;
    }

    public void setEditUserName(String editUserName) {
        this.editUserName = editUserName;
    }

    public String getYysj() {
        return yysj;
    }

    public void setYysj(String yysj) {
        this.yysj = yysj;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getDjzxmc() {
        return djzxmc;
    }

    public void setDjzxmc(String djzxmc) {
        this.djzxmc = djzxmc;
    }

    public String getQymc() {
        return qymc;
    }

    public void setQymc(String qymc) {
        this.qymc = qymc;
    }

    public String getZlRequired() {
        return zlRequired;
    }

    public void setZlRequired(String zlRequired) {
        this.zlRequired = zlRequired;
    }

    public String getFczhRequired() {
        return fczhRequired;
    }

    public void setFczhRequired(String fczhRequired) {
        this.fczhRequired = fczhRequired;
    }

    public String getSqxxlx() {
        return sqxxlx;
    }

    public void setSqxxlx(String sqxxlx) {
        this.sqxxlx = sqxxlx;
    }

    public String getSfczzjxx() {
        return sfczzjxx;
    }

    public void setSfczzjxx(String sfczzjxx) {
        this.sfczzjxx = sfczzjxx;
    }

    public String getSmr() {
        return smr;
    }

    public void setSmr(String smr) {
        this.smr = smr;
    }

    public String getSfzjhm() {
        return sfzjhm;
    }

    public void setSfzjhm(String sfzjhm) {
        this.sfzjhm = sfzjhm;
    }

    public String getSpwxyy() {
        return spwxyy;
    }

    public void setSpwxyy(String spwxyy) {
        this.spwxyy = spwxyy;
    }

    public String getSpwxyymc() {
        return spwxyymc;
    }

    public void setSpwxyymc(String spwxyymc) {
        this.spwxyymc = spwxyymc;
    }

    public String getSpwxyyxq() {
        return spwxyyxq;
    }

    public void setSpwxyyxq(String spwxyyxq) {
        this.spwxyyxq = spwxyyxq;
    }

    public String getZlTm() {
        return zlTm;
    }

    public void setZlTm(String zlTm) {
        this.zlTm = zlTm;
    }

    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }

    public String getUpdateOrgId() {
        return updateOrgId;
    }

    public void setUpdateOrgId(String updateOrgId) {
        this.updateOrgId = updateOrgId;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getQlrzjh() {
        return qlrzjh;
    }

    public void setQlrzjh(String qlrzjh) {
        this.qlrzjh = qlrzjh;
    }

    public String getYwrmc() {
        return ywrmc;
    }

    public void setYwrmc(String ywrmc) {
        this.ywrmc = ywrmc;
    }

    public String getYwrzjh() {
        return ywrzjh;
    }

    public void setYwrzjh(String ywrzjh) {
        this.ywrzjh = ywrzjh;
    }

    public String getQsmln() {
        return qsmln;
    }

    public void setQsmln(String qsmln) {
        this.qsmln = qsmln;
    }

    public String getSkjm() {
        return skjm;
    }

    public void setSkjm(String skjm) {
        this.skjm = skjm;
    }

    public String getFczhList() {
        return fczhList;
    }

    public void setFczhList(String fczhList) {
        this.fczhList = fczhList;
    }

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public String getDjyyMc() {
        return djyyMc;
    }

    public void setDjyyMc(String djyyMc) {
        this.djyyMc = djyyMc;
    }

    public String getYwxtslbh() {
        return ywxtslbh;
    }

    public void setYwxtslbh(String ywxtslbh) {
        this.ywxtslbh = ywxtslbh;
    }

    public String getYgzm() {
        return ygzm;
    }

    public void setYgzm(String ygzm) {
        this.ygzm = ygzm;
    }

    public String getYgdyzm() {
        return ygdyzm;
    }

    public void setYgdyzm(String ygdyzm) {
        this.ygdyzm = ygdyzm;
    }

    public String getSfzjjg() {
        return sfzjjg;
    }

    public void setSfzjjg(String sfzjjg) {
        this.sfzjjg = sfzjjg;
    }

    public String getSwzt() {
        return swzt;
    }

    public void setSwzt(String swzt) {
        this.swzt = swzt;
    }

    public String getFybh() {
        return fybh;
    }

    public void setFybh(String fybh) {
        this.fybh = fybh;
    }

    public String getJfzt() {
        return jfzt;
    }

    public void setJfzt(String jfzt) {
        this.jfzt = jfzt;
    }

    public Double getQdjg() {
        return qdjg;
    }

    public void setQdjg(Double qdjg) {
        this.qdjg = qdjg;
    }

    public String getZlxdm() {
        return zlxdm;
    }

    public void setZlxdm(String zlxdm) {
        this.zlxdm = zlxdm;
    }

    public String getZlxmc() {
        return zlxmc;
    }

    public void setZlxmc(String zlxmc) {
        this.zlxmc = zlxmc;
    }

    public String getYtdm() {
        return ytdm;
    }

    public void setYtdm(String ytdm) {
        this.ytdm = ytdm;
    }

    public String getQllxdm() {
        return qllxdm;
    }

    public void setQllxdm(String qllxdm) {
        this.qllxdm = qllxdm;
    }

    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    public String getSlbhReverse() {
        //写在此处，主要是为了兼容可能没有值的情况
        if (StringUtils.isNotBlank(slbhReverse)) {
            //冗余字段
            StringBuffer buffer = new StringBuffer();
            buffer.append(slbh);
            this.setSlbhReverse(buffer.reverse().toString());
        }
        return slbhReverse;
    }

    public void setSlbhReverse(String slbhReverse) {
        this.slbhReverse = slbhReverse;
    }

    public String getZgzqqdss() {
        return zgzqqdss;
    }

    public void setZgzqqdss(String zgzqqdss) {
        this.zgzqqdss = zgzqqdss;
    }

    public String getZgzqqdssmc() {
        return zgzqqdssmc;
    }

    public void setZgzqqdssmc(String zgzqqdssmc) {
        this.zgzqqdssmc = zgzqqdssmc;
    }

    public String getTddymj() {
        return tddymj;
    }

    public void setTddymj(String tddymj) {
        this.tddymj = tddymj;
    }

    public String getFwdymj() {
        return fwdymj;
    }

    public void setFwdymj(String fwdymj) {
        this.fwdymj = fwdymj;
    }

    public String getQzysxlh() {
        return qzysxlh;
    }

    public void setQzysxlh(String qzysxlh) {
        this.qzysxlh = qzysxlh;
    }

    public String getSfxsyy() {
        return sfxsyy;
    }

    public void setSfxsyy(String sfxsyy) {
        this.sfxsyy = sfxsyy;
    }

    public String getZsid() {
        return zsid;
    }

    public void setZsid(String zsid) {
        this.zsid = zsid;
    }

    public String getSfblysgg() {
        return sfblysgg;
    }

    public void setSfblysgg(String sfblysgg) {
        this.sfblysgg = sfblysgg;
    }

    public String getSqsy() {
        return sqsy;
    }

    public void setSqsy(String sqsy) {
        this.sqsy = sqsy;
    }

    public String getSqsymc() {
        return sqsymc;
    }

    public void setSqsymc(String sqsymc) {
        this.sqsymc = sqsymc;
    }

    public String getSfzf() {
        return sfzf;
    }

    public void setSfzf(String sfzf) {
        this.sfzf = sfzf;
    }

    public String getSfcd() {
        return sfcd;
    }

    public void setSfcd(String sfcd) {
        this.sfcd = sfcd;
    }

    public String getSfcdmc() {
        return sfcdmc;
    }

    public void setSfcdmc(String sfcdmc) {
        this.sfcdmc = sfcdmc;
    }

    public String getZyjjfs() {
        return zyjjfs;
    }

    public void setZyjjfs(String zyjjfs) {
        this.zyjjfs = zyjjfs;
    }

    public String getZyjjfsmc() {
        return zyjjfsmc;
    }

    public void setZyjjfsmc(String zyjjfsmc) {
        this.zyjjfsmc = zyjjfsmc;
    }

    public String getDydklb() {
        return dydklb;
    }

    public void setDydklb(String dydklb) {
        this.dydklb = dydklb;
    }

    public String getDydklbmc() {
        return dydklbmc;
    }

    public void setDydklbmc(String dydklbmc) {
        this.dydklbmc = dydklbmc;
    }

    public String getQlsdfs() {
        return qlsdfs;
    }

    public void setQlsdfs(String qlsdfs) {
        this.qlsdfs = qlsdfs;
    }

    public String getQlsdfsmc() {
        return qlsdfsmc;
    }

    public void setQlsdfsmc(String qlsdfsmc) {
        this.qlsdfsmc = qlsdfsmc;
    }

    public String getBzxrxxcxms() {
        return bzxrxxcxms;
    }

    public void setBzxrxxcxms(String bzxrxxcxms) {
        this.bzxrxxcxms = bzxrxxcxms;
    }

    public String getCxjgsm() {
        return cxjgsm;
    }

    public void setCxjgsm(String cxjgsm) {
        this.cxjgsm = cxjgsm;
    }

    public String getTsszDjzxdm() {
        return tsszDjzxdm;
    }

    public void setTsszDjzxdm(String tsszDjzxdm) {
        this.tsszDjzxdm = tsszDjzxdm;
    }

    public String getTsszDjzxmc() {
        return tsszDjzxmc;
    }

    public void setTsszDjzxmc(String tsszDjzxmc) {
        this.tsszDjzxmc = tsszDjzxmc;
    }

    public String getSwztMc() {
        return swztMc;
    }

    public void setSwztMc(String swztMc) {
        this.swztMc = swztMc;
    }

    public String getSyqx() {
        return syqx;
    }

    public void setSyqx(String syqx) {
        this.syqx = syqx;
    }

    public String getCqly() {
        return cqly;
    }

    public void setCqly(String cqly) {
        this.cqly = cqly;
    }

    public String getCffs() {
        return cffs;
    }

    public void setCffs(String cffs) {
        this.cffs = cffs;
    }

    public String getSdqghid() {
        return sdqghid;
    }

    public void setSdqghid(String sdqghid) {
        this.sdqghid = sdqghid;
    }

    public String getSfzhdk() {
        return sfzhdk;
    }

    public void setSfzhdk(String sfzhdk) {
        this.sfzhdk = sfzhdk;
    }

    public String getSfylqzzdjzm() {
        return sfylqzzdjzm;
    }

    public void setSfylqzzdjzm(String sfylqzzdjzm) {
        this.sfylqzzdjzm = sfylqzzdjzm;
    }

    public String getQlsx() {
        return qlsx;
    }

    public void setQlsx(String qlsx) {
        this.qlsx = qlsx;
    }

    public Date getJfztsj() {
        return jfztsj;
    }

    public void setJfztsj(Date jfztsj) {
        this.jfztsj = jfztsj;
    }

    public String getSdqczr() {
        return sdqczr;
    }

    public void setSdqczr(String sdqczr) {
        this.sdqczr = sdqczr;
    }

    public String getBclyy() {
        return bclyy;
    }

    public void setBclyy(String bclyy) {
        this.bclyy = bclyy;
    }

    public String getCxmd() {
        return cxmd;
    }

    public void setCxmd(String cxmd) {
        this.cxmd = cxmd;
    }

    public String getDsffwsjsj() {
        return dsffwsjsj;
    }

    public void setDsffwsjsj(String dsffwsjsj) {
        this.dsffwsjsj = dsffwsjsj;
    }

    public String getGglx() {
        return gglx;
    }

    public void setGglx(String gglx) {
        this.gglx = gglx;
    }

    public String getGglxmc() {
        return gglxmc;
    }

    public void setGglxmc(String gglxmc) {
        this.gglxmc = gglxmc;
    }

    public String getFbdw() {
        return fbdw;
    }

    public void setFbdw(String fbdw) {
        this.fbdw = fbdw;
    }

    public String getFbdwmc() {
        return fbdwmc;
    }

    public void setFbdwmc(String fbdwmc) {
        this.fbdwmc = fbdwmc;
    }

    public String getySlbh() {
        return ySlbh;
    }

    public void setySlbh(String ySlbh) {
        this.ySlbh = ySlbh;
    }

    public String getDjzsxsdm() {
        return djzsxsdm;
    }

    public void setDjzsxsdm(String djzsxsdm) {
        this.djzsxsdm = djzsxsdm;
    }

    public String getYsdqdm() {
        return ysdqdm;
    }

    public void setYsdqdm(String ysdqdm) {
        this.ysdqdm = ysdqdm;
    }

    public String getYsdqmc() {
        return ysdqmc;
    }

    public void setYsdqmc(String ysdqmc) {
        this.ysdqmc = ysdqmc;
    }

    public String getDjhdbs() {
        return djhdbs;
    }

    public void setDjhdbs(String djhdbs) {
        this.djhdbs = djhdbs;
    }

    public String getSwhdbs() {
        return swhdbs;
    }

    public void setSwhdbs(String swhdbs) {
        this.swhdbs = swhdbs;
    }

    public String getSftsys() {
        return sftsys;
    }

    public void setSftsys(String sftsys) {
        this.sftsys = sftsys;
    }

    public String getCqdw() {
        return cqdw;
    }

    public void setCqdw(String cqdw) {
        this.cqdw = cqdw;
    }

    public String getSfydy() {
        return sfydy;
    }

    public void setSfydy(String sfydy) {
        this.sfydy = sfydy;
    }

    public String getSfxxbl() {
        return sfxxbl;
    }

    public void setSfxxbl(String sfxxbl) {
        this.sfxxbl = sfxxbl;
    }

    public String getSfwcspgz() {
        return sfwcspgz;
    }

    public void setSfwcspgz(String sfwcspgz) {
        this.sfwcspgz = sfwcspgz;
    }

    public String getSfdyzx() {
        return sfdyzx;
    }

    public void setSfdyzx(String sfdyzx) {
        this.sfdyzx = sfdyzx;
    }

    public String getDyzt() {
        return dyzt;
    }

    public void setDyzt(String dyzt) {
        this.dyzt = dyzt;
    }

    public String getWssj() {
        return wssj;
    }

    public void setWssj(String wssj) {
        this.wssj = wssj;
    }

    public String getHssj() {
        return hssj;
    }

    public void setHssj(String hssj) {
        this.hssj = hssj;
    }

    public String getSfyns() {
        return sfyns;
    }

    public void setSfyns(String sfyns) {
        this.sfyns = sfyns;
    }

    public String getSfdb() {
        return sfdb;
    }

    public void setSfdb(String sfdb) {
        this.sfdb = sfdb;
    }

    public String getSfkhdy() {
        return sfkhdy;
    }

    public void setSfkhdy(String sfkhdy) {
        this.sfkhdy = sfkhdy;
    }

    public String getSftsjy() {
        return sftsjy;
    }

    public void setSftsjy(String sftsjy) {
        this.sftsjy = sftsjy;
    }

    public String getDjsfzdzf() {
        return djsfzdzf;
    }

    public void setDjsfzdzf(String djsfzdzf) {
        this.djsfzdzf = djsfzdzf;
    }

    public Date getTjyssj() {
        return tjyssj;
    }

    public void setTjyssj(Date tjyssj) {
        this.tjyssj = tjyssj;
    }

    public String getDkqk() {
        return dkqk;
    }

    public void setDkqk(String dkqk) {
        this.dkqk = dkqk;
    }

    public String getSfdyzzzm() {
        return sfdyzzzm;
    }

    public void setSfdyzzzm(String sfdyzzzm) {
        this.sfdyzzzm = sfdyzzzm;
    }

    public String getCxah() {
        return cxah;
    }

    public void setCxah(String cxah) {
        this.cxah = cxah;
    }

    public String getCxnr() {
        return cxnr;
    }

    public void setCxnr(String cxnr) {
        this.cxnr = cxnr;
    }

    public String getCxjgyq() {
        return cxjgyq;
    }

    public void setCxjgyq(String cxjgyq) {
        this.cxjgyq = cxjgyq;
    }

    public String getLhgxyy() {
        return lhgxyy;
    }

    public void setLhgxyy(String lhgxyy) {
        this.lhgxyy = lhgxyy;
    }

    public String getCxmdst() {
        return cxmdst;
    }

    public void setCxmdst(String cxmdst) {
        this.cxmdst = cxmdst;
    }

    public String getSfjdjfz() {
        return sfjdjfz;
    }

    public void setSfjdjfz(String sfjdjfz) {
        this.sfjdjfz = sfjdjfz;
    }

    public String getSftgxcfw() {
        return sftgxcfw;
    }

    public void setSftgxcfw(String sftgxcfw) {
        this.sftgxcfw = sftgxcfw;
    }

    public String getSfwhbxd() {
        return sfwhbxd;
    }

    public void setSfwhbxd(String sfwhbxd) {
        this.sfwhbxd = sfwhbxd;
    }

    public String getYscqzh() {
        return yscqzh;
    }

    public void setYscqzh(String yscqzh) {
        this.yscqzh = yscqzh;
    }

    public String getSfdygh() {
        return sfdygh;
    }

    public void setSfdygh(String sfdygh) {
        this.sfdygh = sfdygh;
    }

    public String getZmxmid() {
        return zmxmid;
    }

    public void setZmxmid(String zmxmid) {
        this.zmxmid = zmxmid;
    }

    public String getDyzxzmsqr() {
        return dyzxzmsqr;
    }

    public void setDyzxzmsqr(String dyzxzmsqr) {
        this.dyzxzmsqr = dyzxzmsqr;
    }

    public String getDyzxzmsqrzjh() {
        return dyzxzmsqrzjh;
    }

    public void setDyzxzmsqrzjh(String dyzxzmsqrzjh) {
        this.dyzxzmsqrzjh = dyzxzmsqrzjh;
    }
}
