package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/8/14
 * @description
 */
@Getter
@AllArgsConstructor
public enum JfxmEnum {
    /**
     * 住宅类不动产登记收费
     */
    JFXM_ZZL("1", "住宅类不动产登记收费"),
    /**
     * 非住宅类不动产登记收费
     */
    JFZT_FZZL("2", "非住宅类不动产登记收费"),
    /**
     * 工本费
     */
    JFZT_GBF("3", "工本费");

    @Getter
    private String code;

    @Getter
    private String msg;

    /**
     * 根据 code 获取对应的 msg
     */
    public static String getMsgByCode(String code) {
        for (JfxmEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value.getMsg();
            }
        }
        return null;
    }
}
