package cn.gtmap.hlw.core.domain.sign;

import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateFjxxParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateQsrxxParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateQsrxxQswjQsxxParamsModel;
import cn.gtmap.hlw.core.model.GxYyLcdyPz;
import cn.gtmap.hlw.core.model.GxYySqxx;

import java.util.List;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2023/11/9 18:40
 * @description 云签公共方法
 */
public interface SignFlowCommonService {


    /**
     * 云签附件存在验证
     * @param fjxxList 附件信息
     * @param fjlxmc 附件类型名称
     * @return 布尔值
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @version 2023/11/9 18:40
     */
    Boolean isExistsYqFjlx(List<SignFlowsCreateFjxxParamsModel> fjxxList, String fjlxmc);

    /**
     * 云签是否跳过执行
     * @param sqxxList 申请信息结合
     * @return 布尔值
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @version 2024/8/27 19:47
     */
    boolean isSkipSignFlow(List<GxYySqxx> sqxxList);

    /**
     * 处理是否部分转让(即是权利人也是义务人)，仅义务人需要签署
     *
     * @param qsrxxList 签署人信息集合
     * @return List<SignFlowsCreateQsrxxParamsModel>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @version 2023/11/22 12:01
     */
    List<SignFlowsCreateQsrxxParamsModel> getSfxzzrQsrxxList(List<SignFlowsCreateQsrxxParamsModel> qsrxxList);

    /**
     * 设置偏移量
     *
     * @param qsxx       签署信息
     * @param gxYyLcdyPz 流程打印配置
     * @return SignFlowsCreateQsrxxQswjQsxxParamsModel
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @version 2024/5/29 12:01
     */
    SignFlowsCreateQsrxxQswjQsxxParamsModel setPosXy(SignFlowsCreateQsrxxQswjQsxxParamsModel qsxx, GxYyLcdyPz gxYyLcdyPz, Integer index);

    /**
     * 获取流程打印配置
     *
     * @param paramsModel 签署信息
     * @param djyy        登记原因
     * @param fjlx        附件类型
     * @param qlrlx       权利人类型
     * @return SignFlowsCreateQsrxxQswjQsxxParamsModel
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @version 2024/5/29 12:01
     */
    GxYyLcdyPz getGxYyLcdyPz(SignFlowsCreateParamsModel paramsModel, String djyy, String fjlx, String qlrlx);

    /**
     * 组装云签附件信息
     *
     * @param paramsModel 签署信息
     * @param fjlx        附件类型
     * @return SignFlowsCreateFjxxParamsModel
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @version 2024/8/7 16:01
     */
    SignFlowsCreateFjxxParamsModel getSignFlowsCreateFjxxParamsModel(SignFlowsCreateParamsModel paramsModel, String fjlx);
}
