package cn.gtmap.hlw.core.dao.djzx;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.djzx.DjzxQueryDTO;
import cn.gtmap.hlw.core.model.GxYyDjzx;

import java.util.List;

/**
 * 登记中心配置(GxYyDjzx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-29 10:19:06
 */
public interface GxYyDjzxDao {

    /**
     * 通过ID查询单条数据
     *
     * @param djzxdm 主键
     * @return 实例对象
     */
    GxYyDjzx get(String djzxdm);

    /**
     * 新增数据
     *
     * @param gxYyDjzx 实例对象
     */
    void saveOrUpdate(GxYyDjzx gxYyDjzx);

    /**
     * 修改数据
     *
     * @param gxYyDjzx 实例对象
     */
    void update(GxYyDjzx gxYyDjzx);

    /**
     * 修改数据
     *
     * @param paramsDTO 实例对象
     */
    void updateSfyy(DjzxQueryDTO paramsDTO);

    /**
     * 删除
     *
     * @param djzxdm 登记中心代码
     */
    void delete(String djzxdm);

    /**
     * 修改数据
     *
     * @return 影响行数
     */
    List<GxYyDjzx> getDjzxList();

    /**
     * 获取数据
     *
     * @param xzqydmList
     * @return list
     */
    List<GxYyDjzx> getByXzqydm(List<String> xzqydmList);

    /**
     * 分页查询
     *
     * @param queryDTO
     * @return
     */
    PageInfo<GxYyDjzx> page(DjzxQueryDTO queryDTO);

}

