package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyYjsSbxx;

import java.util.List;

/**
 * 一件事申报信息(GxYyYjsSbxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-11-08 09:12:28
 */
public interface GxYyYjsSbxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param uuid 主键
     * @return 实例对象
     */
    GxYyYjsSbxx get(String uuid);

    /**
     * 新增数据
     *
     * @param gxYyYjsSbxx 实例对象
     * @return 影响行数
     */
    void save(GxYyYjsSbxx gxYyYjsSbxx);

    /**
     * 修改数据
     *
     * @param gxYyYjsSbxx 实例对象
     * @return 影响行数
     */
    void update(GxYyYjsSbxx gxYyYjsSbxx);

    /**
     * 根据slbh查询
     * @param slbh
     * @return:List<GxYyYjsSbxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyYjsSbxx> listBySlbh(String slbh);
}

