package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * 互联网系统用户权限明细model
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2025-06-24 09:26:36
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HlwXtYhqxmx implements Serializable {

    /**
     * 主键，用户权限ID
     */
    private String yhqxid;
    /**
     * 接口名称
     */
    private String jkmc;
    /**
     * 接口地址
     */
    private String jkdz;
    /**
     * 权限类型：0(数据范围-全部)、1（数据范围-本人相关）、2(数据范围-本部门)、3(数据范围-本部门及下属部门)，代码中加枚举类型对照
     */
    private String qxlxdm;
    /**
     * 自定义过滤条件{ "field": "sqlx", "operator": "IN", "values": ["100001", "10002"] }
     */
    private String zdygltj;
    /**
     * 自定义限制字段，指定展示字段、脱敏字段等{ "allowed_fields": ["name", "salary", "title"] ,"masked_fields": ["qlrzjh", "qlrlxdh"] }
     */
    private String zdyxzzd;

}

