package cn.gtmap.hlw.core.util.http;

import cn.gtmap.hlw.core.dto.third.dzzz.DzzzShieldSyncAppDTO;
import com.iflytek.fsp.shield.java.sdk.constant.HttpConstant;
import com.iflytek.fsp.shield.java.sdk.constant.SdkConstant;
import com.iflytek.fsp.shield.java.sdk.enums.Method;
import com.iflytek.fsp.shield.java.sdk.enums.ParamPosition;
import com.iflytek.fsp.shield.java.sdk.http.ApiClient;
import com.iflytek.fsp.shield.java.sdk.http.BaseApp;
import com.iflytek.fsp.shield.java.sdk.model.ApiRequest;
import com.iflytek.fsp.shield.java.sdk.model.ApiResponse;

import java.nio.charset.StandardCharsets;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/11/14
 * @description 省级电子证照 请求发起类
 */
public class ShieldSyncApp extends BaseApp {

    public ShieldSyncApp(DzzzShieldSyncAppDTO dzzzShieldSyncAppDTO) {
        this.apiClient = new ApiClient();
        this.apiClient.init();
        this.appId = dzzzShieldSyncAppDTO.getAppId();
        this.appSecret = dzzzShieldSyncAppDTO.getAppSecret();
        this.host = dzzzShieldSyncAppDTO.getHost();
        this.httpPort = dzzzShieldSyncAppDTO.getHttpPort();
        this.httpsPort = dzzzShieldSyncAppDTO.getHttpsPort();
        this.stage = dzzzShieldSyncAppDTO.getStage();
        this.equipmentNo = dzzzShieldSyncAppDTO.getEquipmentNo();
        this.signStrategyUrl = dzzzShieldSyncAppDTO.getSignStrategyUrl();
        this.tokenUrl = dzzzShieldSyncAppDTO.getTokenUrl();
        this.publicKey = dzzzShieldSyncAppDTO.getPublicKey();
        //关闭云锁验证
        this.icloudlockEnabled = dzzzShieldSyncAppDTO.getIcloudlockEnabled();
    }

    /**
     * Version:202311182313162065 //todo:驼峰
     */
    public ApiResponse ZZK_OPENAPI_GATEWAY(byte[] body, String method, String timestamp, String nonce, String sign) {
        ApiRequest apiRequest = new ApiRequest(HttpConstant.SCHEME_HTTP, Method.POST, "/api-0.8.20/zzwk-service/openApi/gateway", SdkConstant.AUTH_TYPE_ENCRYPT, "1");
        apiRequest.setBody(body);

        apiRequest.addParam("method", method, ParamPosition.HEADER, true);

        apiRequest.addParam("timestamp", timestamp, ParamPosition.HEADER, true);

        apiRequest.addParam("nonce", nonce, ParamPosition.HEADER, true);

        apiRequest.addParam("sign", sign, ParamPosition.HEADER, true);

        return syncInvoke(apiRequest);
    }

    public String sendRequest(String paramObj, String path) {
        byte[] body = paramObj.getBytes(StandardCharsets.UTF_8);
        ApiRequest apiRequest = new ApiRequest(HttpConstant.SCHEME_HTTP, Method.POST, path, SdkConstant.AUTH_TYPE_ENCRYPT, "a2b55e65007d45b3bc1e045581ddfec1");
        apiRequest.setBody(body);
        ApiResponse apiResponse = syncInvoke(apiRequest);
        return new String(apiResponse.getBody(), StandardCharsets.UTF_8);
    }

}