package cn.gtmap.hlw.core.dto.platform;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author shenfei
 * @version 1.0
 * @description: 角色信息
 * @date 2025/8/6 15:07
 */
@Data
public class RoleDTO {
    /*
     *  主键
     * */
    private String id;

    /*
     *  编码
     * */
    private String name;

    /*
     *  中文描述/名称
     * */
    private String alias;

    /*
     * 类型，存储type表的code
     * */
    private String type;

    /*
     * 用途，2个固定值，岗位：post，系统角色：system
     * */
//    private String usage;

    /*
     *  角色等级
     * */
    private int level;

    /*
     *  1 ：正常 0：禁用
     * */
    private int enabled;

    /*
     *  创建时间
     * */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createAt;

    /*
     *  更新时间
     * */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateAt;

    /*
     *  继承角色列表
     * */
    private List<RoleDTO> parentRecords;

    /*
     *  互斥角色列表
     * */
    private List<RoleDTO> excludeRecords;

    /*
     *  可配置角色列表
     * */
    private List<String> gradingRoleIds;


}
