package cn.gtmap.hlw.core.dao.dict;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.dict.djyy.ZdDjyyPageParamsDTO;
import cn.gtmap.hlw.core.model.GxYyZdDjyy;

import java.util.List;

/**
 * 申请类型与登记原因关联表(GxYyZdDjyy)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-26 18:52:12
 */
public interface GxYyZdDjyyDao {

    /**
     * 通过ID查询单条数据
     *
     * @param id
     * @return 实例对象
     */
    GxYyZdDjyy get(String id);

    /**
     * 新增数据
     *
     * @param gxYyZdDjyy 实例对象
     * @return 影响行数
     */
    void saveDjyy(GxYyZdDjyy gxYyZdDjyy);

    /**
     * 修改数据
     *
     * @param gxYyZdDjyy 实例对象
     * @return 影响行数
     */
    void update(GxYyZdDjyy gxYyZdDjyy);

    /**
     * 获取数据
     *
     * @param sqlx   申请类型
     * @param xyqydm 区域代码
     * @return 影响行数
     */
    List<GxYyZdDjyy> getGxYyZdDjyyList(String sqlx, String xyqydm);
    /**
     * 获取数据
     *
     * @param sqlxList   申请类型集合
     * @param xyqydm 区域代码
     * @return 影响行数
     */
    List<GxYyZdDjyy> getBySqlxList(List<String> sqlxList, String xyqydm);

    /**
     *分页查询
     * @param paramsDTO
     * @return
     */

    PageInfo<GxYyZdDjyy> queryPage(ZdDjyyPageParamsDTO paramsDTO);

    /**
     * 删除
     * @param id 主键
     * @return 删除的数量
     */
    int delete(String id);

    /**
     * 字典登记原因表--查询全部数据
     * @return GxYyZdDjyyPO集合
     */
    List<GxYyZdDjyy> getAll();

    /**
     * 保存更新
     * @param gxYyZdDjyy
     */
    void saveOrUpdateDjyy(GxYyZdDjyy gxYyZdDjyy);

    /**
     * 根据sqlx查询
     * @param sqlx
     * @return List<GxYyZdDjyyPO>
     */
    List<GxYyZdDjyy> listBySqlx(String sqlx);
    /**
     * 批量保存
     * @param zdDjyyList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void insertBatchSomeColumn(List<GxYyZdDjyy> zdDjyyList);
    /**
     * 根据sqlx删除
     * @param sqlx
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void deleteBySqlx(String sqlx);
    /**
     * 批量保存或更新
     * @param zdDjyyList
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    void saveOrUpdateBatch(List<GxYyZdDjyy> zdDjyyList);
}

