package cn.gtmap.hlw.core.util.tzgtj;

import cn.gtmap.hlw.core.service.IWebService;
import lombok.extern.slf4j.Slf4j;

import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * @author gaorui
 */
@Slf4j
public class TzGtjWebUtils extends Service {

    private static URL WEBSERVICEIMPLSERVICE_WSDL_LOCATION;

//    static {
//        URL url = null;
//        try {
//            URL baseUrl;
//            baseUrl = TzGtjWebUtils.class.getResource(".");
//            url = new URL(baseUrl,
//                    "http://2.176.193.78:60000/WebServiceWithGtj?wsdl");
//        } catch (MalformedURLException e) {
//            log.error("Failed to create URL for the wsdl Location: 'http://2.176.193.78:60000/WebServiceWithGtj?wsdl', retrying as a local file");
//            log.error(e.getMessage());
//        }
//        WEBSERVICEIMPLSERVICE_WSDL_LOCATION = url;
//    }

    public static void init(String gtjUrl) {
        URL url = null;
        try {
            URL baseUrl;
            baseUrl = TzGtjWebUtils.class.getResource(".");
            url = new URL(baseUrl,
                    gtjUrl);
        } catch (MalformedURLException e) {
            log.error("Failed to create URL for the wsdl Location: " + gtjUrl + ", retrying as a local file");
            log.error(e.getMessage());
        }
        WEBSERVICEIMPLSERVICE_WSDL_LOCATION = url;
    }

    public TzGtjWebUtils(URL wsdlLocation, QName serviceName) {
        super(wsdlLocation, serviceName);
    }

    public TzGtjWebUtils() {
        super(WEBSERVICEIMPLSERVICE_WSDL_LOCATION, new QName(
                "http://impl.com/", "WebServiceImplService"));
    }

    /**
     * @return returns IWebService
     */
    @WebEndpoint(name = "WebServiceImplPort")
    public IWebService getWebServiceImplPort() {
        return super.getPort(
                new QName("http://impl.com/", "WebServiceImplPort"),
                IWebService.class);
    }
}
