package cn.gtmap.hlw.core.util.dozer;

import java.util.Collection;
import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/6/27
 * @description dozer工具类
 */
public interface DozerRepository {
    /**
     * 非标准字段转换成标准字段（注解式）
     * @param var1
     * @param var2
     * @return
     */
    <T> T copyClass(Object var1, Class<T> var2);

    /**
     * 非标准字段转换成标准字段（xml配置）
     * @param var1
     * @param var2
     * @param xmlName
     * @return T
     */
    <T> T copyClassByXml(Object var1, Class<T> var2, String xmlName);

    /**
     * 非标准字段转换成标准字段（xml配置）
     * @param var1
     * @param var2
     * @param xmlNameList
     * @return T
     */
    <T> T copyClassByXml(Object var1, Class<T> var2, List<String> xmlNameList);

    /**
     * 非标准字段转换成标准字段（xml配置）
     * @param sourceList
     * @param var2
     * @param xmlName
     * @return
     */
    <T> List<T> copyClassListByXml(Collection sourceList, Class<T> var2, String xmlName);

    /**
     * 非标准字段转换成标准字段（xml配置）
     * @param sourceList
     * @param var2
     * @return List
     */
    <T> List<T> copyClassList(Collection sourceList, Class<T> var2);
}
