package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyFjxm;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Map;

/**
 * (GxYyFjxm)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:45
 */
public interface GxYyFjxmRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param xmid 主键
     * @return 实例对象
     */
    GxYyFjxm get(String xmid);

    /**
     * 新增数据
     *
     * @param gxYyFjxm 实例对象
     * @return 影响行数
     */
    void save(GxYyFjxm gxYyFjxm);

    /**
     * 修改数据
     *
     * @param gxYyFjxm 实例对象
     * @return 影响行数
     */
    void update(GxYyFjxm gxYyFjxm);

    /**
     * 删除数据
     *
     * @param xmid 项目ID
     * @return 影响行数
     */
    int delete(String xmid);

    /**
     * 根据SLBH查询fjxm
     * @param slbh
     * @return
     */
    List<GxYyFjxm> getBySlbh(String slbh);

    /**
     * 根据sqid查询fjxm
     * @param sqid
     * @return
     */
    List<GxYyFjxm> getBySqid(String sqid);

    /**
     * 根据slbh和附件类型查询附件目录
     * @param slbh
     * @param fjlx
     * @return
     */
    GxYyFjxm getBySlbhAndFjlx(String slbh, String fjlx);

    /**
     * 根据slbh和附件类型查询附件目录
     * @param slbh
     * @param fjlxList
     * @return
     */
    List<GxYyFjxm> getBySlbhAndFjlx(String slbh, List<String> fjlxList);

    /**
     * 批量新增（一次性插入）
     *
     * @param batchList
     * @return int
     */
    int insertBatchSomeColumn(@Param("list") List<GxYyFjxm> batchList);

    /**
     * 根据slbh获取排序后的fjxm
     *
     * @param slbh
     * @return int
     */
    List<GxYyFjxm> getFjxmOrderByXh(@Param("slbh") String slbh);

    /**
     * 根据列名查询
     * @param paramMap
     * @return:List<GxYyFjxm>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyFjxm> getListByMap(Map<String, Object> paramMap);
    /**
     * 根据slbh和qlrlx查询
     */
    List<GxYyFjxm> getBySlbhAndQlrlx(String slbh, String qlrlx);
    /**
     * 根据slbh、fjlx删除附件项目
     * @param slbh
     * @param list
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void delBySlbhAndFjlxs(String slbh, List<String> list);

    /**
     * 根据xmidList查询附件项目
     */
    List<GxYyFjxm> getByXmidList(List<String> xmidList);
}

