package cn.gtmap.hlw.coredk.utils;

import cn.hutool.poi.excel.ExcelWriter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
 * @version 1.0 2025/7/14
 * @description 一窗通用Excel文件生成
 */
@Slf4j
public class DzkfExcelFileUtil {
    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param
     * @return
     * @description 生成Excel文件通用方法
     */
    public static File getFile(File file, List<Map> dataList, ExcelWriter writer) {
        return getFile(file, dataList, writer, true);
    }
    public static File getFile(File file, List<Map> dataList, ExcelWriter writer, Boolean isSetDefaultHeight) {
        if(CollectionUtils.isNotEmpty(dataList)){
            Map<String, Object> map = dataList.get(0);
            int idx = 0;
            for (String key : map.keySet()) {
                writer.setColumnWidth(idx, 30);
                idx++;
            }
            int size = dataList.size() + 1;
            if (isSetDefaultHeight) {
                for (int i = 0; i < size; i++) {
                    writer.setRowHeight(i, 20);
                }
            }

            try {
                FileOutputStream outputStream = new FileOutputStream(file);
                writer.flush(outputStream);
            } catch (Exception e) {
                log.error("导出Excel文件失败", e);
            } finally {
                // 关闭writer，释放内存
                writer.close();
                file.delete();
            }
        }
        return file;
    }



    /**
     * 添加一行合并单元格，并为左侧和右侧单元格设置内容和对齐样式。
     *
     * @param writer            ExcelWriter 实例
     * @param rowNum            行号
     * @param leftStartCol      左侧合并起始列
     * @param leftEndCol        左侧合并结束列
     * @param leftContent       左侧单元格内容
     * @param leftAlignment     左侧对齐方式
     * @param rightStartCol     右侧合并起始列
     * @param rightEndCol       右侧合并结束列
     * @param rightContent      右侧单元格内容
     * @param rightAlignment    右侧对齐方式
     */
    public static void addMergedRowWithStyles(ExcelWriter writer, int rowNum, int leftStartCol, int leftEndCol, String leftContent,
                                              HorizontalAlignment leftAlignment, int rightStartCol, int rightEndCol,
                                              String rightContent, HorizontalAlignment rightAlignment) {
        // 左侧合并
        writer.merge(rowNum, rowNum, leftStartCol, leftEndCol, leftContent, false);
        Cell leftCell = writer.getOrCreateCell(rowNum, leftStartCol);
        CellStyle leftStyle = writer.createCellStyle();
        leftStyle.setAlignment(leftAlignment);
        leftCell.setCellStyle(leftStyle);

        // 右侧合并
        writer.merge(rowNum, rowNum, rightStartCol, rightEndCol, rightContent, false);
        Cell rightCell = writer.getOrCreateCell(rowNum, rightStartCol);
        CellStyle rightStyle = writer.createCellStyle();
        rightStyle.setAlignment(rightAlignment);
        rightCell.setCellStyle(rightStyle);
    }
}
