package cn.gtmap.hlw.core.repository;


import cn.gtmap.hlw.core.model.HlwSqxxSlxx;

import java.util.List;

/**
 * 互联网申请信息受理信息表(hlw_sqxx_slxx)表数据库访问层
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2025-06-24 10:21:46
 */
public interface HlwSqxxSlxxRepository {

    /**
     * 根据受理编号查询数据
     *
     * @param slbh 受理编号
     * @return HlwSqxxSlxx
     */
    HlwSqxxSlxx getBySlbh(String slbh);

    int insert(HlwSqxxSlxx slxxPo);

    int updateById(HlwSqxxSlxx slxx);

    int deleteBySlbh(String slbh);

    void saveOrUpdate(HlwSqxxSlxx slxx);

    void saveOrUpdateBatch(List<HlwSqxxSlxx> slxxList);

    void updateByWrapper(HlwSqxxSlxx slxx);
}

