package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxHq;

import java.util.List;

/**
 * 在线申请--会签(GxYySqxxHq)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:46
 */
public interface GxYySqxxHqRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param hqid 主键
     * @return 实例对象
     */
    GxYySqxxHq get(Integer hqid);
    /**
     * 获取数据
     *
     * @param qlrid
     * @param slbh
     * @return 实例对象
     */
    List<GxYySqxxHq> getByParams(String qlrid,String slbh);
    /**
     * 通过权利人ID查询集合数据
     *
     * @param qlrIdList 权利人ID
     * @return 实例对象
     */
    List<GxYySqxxHq> getByQlrIdList(List<String> qlrIdList);

    /**
     * 通过权利人ID查询单条数据
     *
     * @param qlrid 权利人ID
     * @return 实例对象
     */
    List<GxYySqxxHq> getByQlrid(String qlrid);

    /**
     * 新增数据
     *
     * @param gxYySqxxHq 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxHq gxYySqxxHq);

    /**
     * 修改数据
     *
     * @param gxYySqxxHq 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxHq gxYySqxxHq);

    /**
     * 删除数据
     *
     * @param qlrid 权利人ID
     * @return 影响行数
     */
    int deleteByQlrid(String qlrid);

    /**
     * 删除数据
     *
     * @param jhrid 监护人ID
     * @return 影响行数
     */
    int deleteByJhrid(String jhrid);
    /**
     * 删除数据
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    int deleteBySlbh(String slbh);

    /**
     * 根据受理编号获取会签信息
     * @param slbh 受理编号
     * @return:GxYySqxxHq
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYySqxxHq> getBySlbh(String slbh);

    /**
     * 批量保存
     * @param gxYySqxxHqList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void saveBatch(List<GxYySqxxHq> gxYySqxxHqList);

    /**
     * 批量保存或更新
     * @param gxYySqxxHqList
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    void saveOrUpdateBatch(List<GxYySqxxHq> gxYySqxxHqList);

    /**
     * 通过sqlbhList查询集合数据
     *
     * @param sqlbhList
     * @return 实例对象
     */
    List<GxYySqxxHq> getBySlbhList(List<String> sqlbhList);

    /**
     * 通过sqidList删除数据
     *
     * @param sqidList 申请id
     * @return 影响行数
     */
    int deleteBySlbhList(List<String> sqidList);

    /**
     * 更新会签状态(是否认证)
     * @param gxYySqxxHq
     */
    void updateSqxxHqSfrz(GxYySqxxHq gxYySqxxHq);
}

