package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxFpxx;

import java.util.List;

/**
 * 申请信息发票信息表(GxYySqxxFpxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:44
 */
public interface GxYySqxxFpxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYySqxxFpxx get(String id);

    /**
     * 新增数据
     *
     * @param gxYySqxxFpxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxFpxx gxYySqxxFpxx);

    /**
     * 修改数据
     *
     * @param gxYySqxxFpxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxFpxx gxYySqxxFpxx);

    /**
     * 通过sqidList查询集合数据
     *
     * @param sqidList
     * @return 实例对象
     */
    List<GxYySqxxFpxx> list(List<String> sqidList);

    /**
     * 通过sqidList删除数据
     *
     * @param sqidList
     * @return 影响行数
     */
    int deleteBySqidList(List<String> sqidList);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 保存或更新发票信息
     */
    void saveOrUpdate(GxYySqxxFpxx gxYySqxxFpxx);
    /**
     * 批量保存
     * @param fpxxList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveBatch(List<GxYySqxxFpxx> fpxxList);
    /**
     * 根据sqid 查询
     * @param sqid
     * @return:java.util.List<cn.gtmap.hlw.domain.sqxx.model.GxYySqxxFpxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYySqxxFpxx> listBySqid(String sqid);
    /**
     * 根据sqid删除
     * @param sqid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void delBySqid(String sqid);
}

