package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyQlrJhr;

import java.util.List;

/**
 * 权利人_监护人信息(GxYyQlrJhr)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:46
 */
public interface GxYyQlrJhrRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param jhrid 主键
     * @return 实例对象
     */
    GxYyQlrJhr get(String jhrid);

    /**
     * 新增数据
     *
     * @param gxYyQlrJhr 实例对象
     * @return 影响行数
     */
    void save(GxYyQlrJhr gxYyQlrJhr);

    /**
     * 修改数据
     *
     * @param gxYyQlrJhr 实例对象
     * @return 影响行数
     */
    void update(GxYyQlrJhr gxYyQlrJhr);

    /**
     * 批量新增或修改数据
     *
     * @param jhrList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYyQlrJhr> jhrList);
    /**
     * 通过申请ID查询监护人集合
     *
     * @param sqid 申请ID
     * @return 影响行数
     */
    List<GxYyQlrJhr> list(String sqid);

    /**
     * 通过qlrid查询监护人集合
     *
     * @param qlrid 权利人ID
     * @return 结果集
     */
    List<GxYyQlrJhr> getByQlrid(String qlrid);
    /**
     * 通过qlrid查询监护人集合
     *
     * @param qlridList 权利人ID
     * @return 结果集
     */
    List<GxYyQlrJhr> getByQlridList(List<String> qlridList);

    /**
     * 通过jhrid删除数据
     *
     * @param jhrid 监护人ID
     * @return 影响行数
     */
    int delete(String jhrid);

    /**
     * 通过sqid集合查询监护人集合
     *
     * @param sqIdList 申请id集合
     * @return 结果集
     */
    List<GxYyQlrJhr> getBySqidList(List<String> sqIdList);

    /**
     * 通过qlrid集合查询监护人集合
     *
     * @param qlrIdList 权利人id集合
     * @return 结果集
     */
    List<GxYyQlrJhr> getListByQlrids(List<String> qlrIdList);

    /**
     * 通过qlrid删除数据
     *
     * @param qlrIdList 权利人ID
     * @return 影响行数
     */
    void deleteByQlrids(List<String> qlrIdList);
}

