package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyCdxx;

import java.util.List;

/**
 * 裁定信息(GxYyCdxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:46
 */
public interface GxYyCdxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param cdxxId 主键
     * @return 实例对象
     */
    GxYyCdxx get(String cdxxId);

    /**
     * 新增数据
     *
     * @param gxYyCdxx 实例对象
     * @return 影响行数
     */
    void save(GxYyCdxx gxYyCdxx);

    /**
     * 修改数据
     *
     * @param gxYyCdxx 实例对象
     * @return 影响行数
     */
    void update(GxYyCdxx gxYyCdxx);

    /**
     * 新增或修改数据
     *
     * @param gxYyCdxx 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYyCdxx gxYyCdxx);
    /**
     * 根据受理编号查询
     * @param slbh
     * @return:java.util.List<cn.gtmap.hlw.core.model.GxYyCdxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyCdxx> listBySlbh(String slbh);
}

