package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyAhfwtc;

import java.util.List;

/**
 * (GxYyAhfwtc)表数据库访问层
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2023-09-04 11:06:49
 */
public interface GxYyAhfwtcRepository {


    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyAhfwtc get(Integer id);

    /**
     * 新增数据
     *
     * @param gxYyAhfwtc 实例对象
     * @return 影响行数
     */
    void save(GxYyAhfwtc gxYyAhfwtc);

    /**
     * 修改数据
     *
     * @param gxYyAhfwtc 实例对象
     * @return 影响行数
     */
    void update(GxYyAhfwtc gxYyAhfwtc);


    /**
     * 通过ID删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int delete(Integer id);

    /**
     * 批量更新或插入
     *
     * @param gxYyAhfwtcList
     */
    void saveOrUpdateBatch(List<GxYyAhfwtc> gxYyAhfwtcList);

    /**
     * 通过多条件查询数据集合
     *
     * @param slbh   受理编号
     * @param qlrzjh 权利人证件号
     * @param qlrlx  权利人类型
     * @param qlrid
     * @return 数据集合
     */
    List<GxYyAhfwtc> get(String slbh, String qlrzjh, String qlrlx, String qlrid);

    /**
     * 通过slbh删除数据集合
     *
     * @param slbhList 受理编号集合
     */
    void deleteBatchBySlbh(List<String> slbhList);

    /**
     * 删除+保存
     * @param qlrid
     * @param gxYyAhfwtcList
     */
    void deleteAndSave(String qlrid, List<GxYyAhfwtc> gxYyAhfwtcList);

    /**
     * 批量插入
     * @param gxYyAhfwtcList
     */
    void saveBatch(List<GxYyAhfwtc> gxYyAhfwtcList);
}

