package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 缴费项目(GxYyZdJfxm)表实体类BO
 *
 * @author makejava
 * @since 2023-06-26 18:54:25
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyZdJfxm implements Serializable {

    private static final long serialVersionUID = -6078227669915152204L;
    /**主键 */
    private String id;

    /**执收单位代码*/
    private String zsdwdm;

    /**执收单位名称*/
    private String zsdwmc;

    /**收费项目代码*/
    private String sfxmdm;

    /**收费项目名称*/
    private String sfxmmc;

    /**单位代码*/
    private String dwdm;

    /**单位名称 */
    private String dwmc;

    /**标准(元)*/
    private String bz;

    /**数据来源（默认HLW：互联网）gx_yy_xtjr.xtdm*/
    private String sjly;

    /**是否删除（0:未删除，1：删除）*/
    private Integer isDelete;

    /**创建时间*/
    private Date createTime;

    /**修改时间*/
    private Date updateTime;

    /**创建人员(gx_yy_user.USER_GUID)*/
    private String createUser;

    /**修改人员(gx_yy_user.USER_GUID)*/
    private String updateUser;

    /**区域代码*/
    private String qydm;

    /**开票用户*/
    private String kpyh;

    /**缴费项目代码（1：住宅类不动产登记收费;2：非住宅类不动产登记收费;3：工本费）*/
    private String jfxmdm;
    /**
     * 收费说明代码
     */
    private String sfsmdm;
    /**
     * 收费类型代码
     */
    private String sflxdm;

}

