package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/8/3
 * @description
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYySqxxGhxxSpxxQuery implements Serializable {
    private static final long serialVersionUID = -1438911771468552062L;

    /**
     * sqid
     */
    private String sqid;
    /**
     * slbh
     */
    private String slbh;

    /**
     * 申请类型 gx_yy_sqxx.sqlx
     */
    private String sqlx;

    /**
     * 申请类型名称 gx_yy_zd_sqlx.mc
     */
    private String sqlxmc;
    /**
     * 坐落 gx_yy_sqxx_ghxx.zl
     */
    private String zl;

    /**
     * 坐落 gx_yy_sqxx.ywxtslbh
     */
    private String ywxtslbh;

    /**
     * 权利人名称(转移流程qlrmc)
     * 组合流程：gx_yy_zd_sqlx.sfzh=0，gx_yy_zd_sqlx.SFDY=1时，gx_yy_sqxx.qlrmc
     * 非组合流程：gx_yy_zd_sqlx.sfzh=1，gx_yy_zd_sqlx.SFDY=1时，gx_yy_sqxx.qlrmc
     */
    private String qlrmc;

    /**
     * 义务人名称
     * 组合流程：gx_yy_zd_sqlx.sfzh=0，gx_yy_zd_sqlx.SFDY=1时，gx_yy_sqxx.ywrmc
     * 非组合流程：gx_yy_zd_sqlx.sfzh=1，gx_yy_zd_sqlx.SFDY=1时，gx_yy_sqxx.ywrmc
     * 非组合流程：gx_yy_zd_sqlx.sfzh=1，gx_yy_zd_sqlx.SFDY=0时，gx_yy_sqxx.ywrmc
     */
    private String ywrmc;

    /**
     * 审批状态 gx_yy_sqxx_spxx.SPZT  状态代码同受理状态
     */
    private String spzt;
    /**
     * 审批状态名称 gx_yy_sqxx_spxx  状态名称同受理状态名称
     */
    private String spztmc;

    /**
     * 审批信息 gx_yy_sqxx_spxx.spxx  审批信息
     */
    private String spxx;

    /**
     * 是否过户 gx_yy_sqxx_spxx.spxx.SGH DGH QGH GDGH WLGH  统一对照成整个字段
     */
    private String sfgh;

    /**
     * 过户号 gx_yy_sqxx_spxx.spxx.SFHH DFHH QFHH GDHH WLHH  统一对照成整个字段
     */
    private String ghh;

    /**
     * 过户信息id gx_yy_sqxx_ghxx.id
     */
    private String ghxxid;
    /**
     * 新户主名称
     */
    private String xhzmc;
    /**
     * 户主名称
     */
    private String hzmc;

}
