package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 部门物流信息(GxYyOrgWlxx)表实体类BO
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyOrgWlxx implements Serializable {
    private static final long serialVersionUID = -1617264699045659867L;
    /**主键 */
    private String id;

    /**部门ID（gx_yy_org.org_id）*/
    private String orgId;

    /**  /领证人名称*/
    private String lzrmc;

    /** 领证人证件种类代码*/
    private String lzrzjzldm;

    /** 领证人证件号*/
    private String lzrzjh;

    /** 领证人联系电话*/
    private String lzrlxdh;

    /**创建时间*/
    private Date createTime;

    /**修改时间*/
    private Date updateTime;

    /**创建人员(gx_yy_user.USER_GUID)*/
    private String createUser;

    /**修改人员(gx_yy_user.USER_GUID)*/
    private String updateUser;

    /**是否为所有支行领证人（Y,N选是则同步当前领证人信息作为其所有子行领证人信息）*/
    private String syzhlzr;


}

