package cn.gtmap.hlw.core.model.CrossRiver;


import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2019/6/12 17:33
 * @description 抵押 -- 抵押权义务人
 */
public class DyYwrEntity implements Serializable {
    private static final long serialVersionUID = -4535063456705508859L;

    /**
     * 权利人名称
     */
    private String qlrmc;

    /**
     * 权利人证件号
     */
    private String qlrzjh;

    /**
     * 权利人证件种类
     */
    private String qlrzjzl;

    /**
     * 权利人证件种类名称
     */
    private String qlrzjmc;

    /**
     * 权利人联系电话
     */
    private String qlrlxdh;

    /**
     * 共有方式
     */
    //@DictConversion(type = DataDictUtils.table_gyfs, rule = DataDictUtils.GETDMBYMC)
    private String gyfs;

    /**
     * 共有方式名称
     */
    private String gyfsmc;

    /**
     * 共有比例
     */
    private String gybl;

    /**
     * 权利比例
     */
    private String qlbl;

    /**
     * 顺序号
     */
    private String sxh;

    /**
     * 产权证号
     */
    private String cqzh;

    /**
     * 登簿日期（登记时间）
     */
    private String djsj;

    /**
     * 共有方式名称
     */
    private String gyfsMc;
    /**
     * 权利人证件种类代码
     * 证件类型判断，如果是6：组织机构代码，或者7：营业执照 ，那么权利人种类代码	qlrzldm：2   qlrzlmc：企业；否则为qlrzldm：1 qlrzlmc：个人，如果为空默认为1个人
     */
    private String qlrzldm;

    /**
     * 权利人种类名称
     */
    private String qlrzlmc;

    /**
     * 抵押人法定代表人
     */
    private String dyrfddbr;

    /**
     * 抵押人法定代表人联系电话
     */
    private String dyrfddbrlxdh;

    /**
     * 抵押人法定代表人证件种类代码
     */
    private String dyrfddbrzjzl;

    /**
     * 抵押人法定代表人证件种类名称
     */
    private String dyrfddbrzjzlmc;

    /**
     * 抵押人法定代表人证件号
     */
    private String dyrfddbrzjh;

    /**
     * 权利人通讯地址
     */
    private String qlrtxdz;

    /**
     * 抵押人通讯地址（接口文档上字段）
     */
    private String dyrtxdz;

    /**
     * 权利人邮编
     */
    private String qlryb;

    /**
     * 权利人代理人
     */
    private String qlrdlr;

    /**
     * 权利人代理人名称
     */
    private String qlrdlrmc;

    /**
     * 权利人代理人联系电话
     */
    private String qlrdlrlxdh;

    /**
     * 代理人证件种类
     */
    private String qlrdlrzjzl;

    /**
     * 代理人证件号
     */
    private String qlrdlrzjh;

    /**
     * 抵押人代理人
     */
    private String dyrdlr;

    /**
     * 抵押人代理人证件种类代码
     */
    private String dyrdlrzjzldm;

    /**
     * 抵押人代理人证件种类名称
     */

    private String dyrdlrzjzlmc;

    /**
     * 抵押人代理人证件号
     */
    private String dyrdlrzjh;

    /**
     * 抵押人代理人联系电话
     */
    private String dyrdlrlxdh;

    /**
     * 权利人名称脱敏
     */
    private String qlrmcTm;

    /**
     * 权利人证件号脱敏
     */
    private String qlrzjhTm;

    /**
     * 权利人法定代表人
     */
    private String qlrfddbr;

    /**
     * 权利人法定代表人证件种类代码
     */
    private String qlrfddbrzjzl;

    /**
     * 权利人法定代表人证件种类名称
     */
    private String qlrfddbrzjzlmc;

    /**
     * 权利人法定代表人证件号
     */
    private String qlrfddbrzjh;

    /**
     * 是否电子签章代码 1是 0否
     */
    private String sfdzqzdm;
    /**
     * 泰兴手机端 档案查询出参数 中天
     */
    private String qlrlx;

    public String getQlrlx() {
        return qlrlx;
    }

    public void setQlrlx(String qlrlx) {
        this.qlrlx = qlrlx;
    }

    public String getDyrdlr() {
        return dyrdlr;
    }

    public void setDyrdlr(String dyrdlr) {
        this.dyrdlr = dyrdlr;
    }

    public String getDyrdlrzjzldm() {
        return dyrdlrzjzldm;
    }

    public void setDyrdlrzjzldm(String dyrdlrzjzldm) {
        this.dyrdlrzjzldm = dyrdlrzjzldm;
    }

    public String getDyrdlrzjzlmc() {
        return dyrdlrzjzlmc;
    }

    public void setDyrdlrzjzlmc(String dyrdlrzjzlmc) {
        this.dyrdlrzjzlmc = dyrdlrzjzlmc;
    }

    public String getDyrdlrzjh() {
        return dyrdlrzjh;
    }

    public void setDyrdlrzjh(String dyrdlrzjh) {
        this.dyrdlrzjh = dyrdlrzjh;
    }

    public String getDyrdlrlxdh() {
        return dyrdlrlxdh;
    }

    public void setDyrdlrlxdh(String dyrdlrlxdh) {
        this.dyrdlrlxdh = dyrdlrlxdh;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getQlrzjh() {
        return qlrzjh;
    }

    public void setQlrzjh(String qlrzjh) {
        this.qlrzjh = qlrzjh;
    }

    public String getQlrzjzl() {
        return qlrzjzl;
    }

    public void setQlrzjzl(String qlrzjzl) {
        /*
          @author <a href="mailto:huangyongkai@gtmap.cn">huangyongkai</a>
         * @description qlrzjzl为空默认身份证
         */
        if (StringUtils.isBlank(qlrzjzl)) {
            this.qlrzjmc = "身份证";
            this.qlrzjzl = "1";
        } else if (qlrzjzl.matches("[0-9]{1,}")) {
            //传数字
            this.qlrzjzl = qlrzjzl;
            switch (qlrzjzl) {
                case "2":
                    this.qlrzjmc = "港澳台身份证";
                    break;
                case "3":
                    this.qlrzjmc = "护照";
                    break;
                case "4":
                    this.qlrzjmc = "户口簿";
                    break;
                case "5":
                    this.qlrzjmc = "军官证（士兵证）";
                    break;
                case "6":
                    this.qlrzjmc = "组织机构代码";
                    break;
                case "7":
                    this.qlrzjmc = "营业执照";
                    break;
                case "8":
                    this.qlrzjmc = "统一社会信用代码";
                    break;
                case "9":
                    this.qlrzjmc = "外国人永久居留证";
                    break;
                case "99":
                    this.qlrzjmc = "其它";
                    break;
                case "1":
                default:
                    this.qlrzjmc = "身份证";
                    break;
            }
        } else {
            //传中文
            this.qlrzjmc = qlrzjzl;
            switch (qlrzjzl) {
                case "港澳台身份证":
                    this.qlrzjzl = "2";
                    break;
                case "护照":
                    this.qlrzjzl = "3";
                    break;
                case "户口簿":
                    this.qlrzjzl = "4";
                    break;
                case "军官证（士兵证）":
                    this.qlrzjzl = "5";
                    break;
                case "组织机构代码":
                    this.qlrzjzl = "6";
                    break;
                case "营业执照":
                    this.qlrzjzl = "7";
                    break;
                case "社会信用代码":
                case "统一社会信用代码":
                    this.qlrzjzl = "8";
                    break;
                case "外国人永久居留证":
                    this.qlrzjzl = "9";
                    break;
                case "其它":
                    this.qlrzjzl = "99";
                    break;
                case "身份证":
                default:
                    this.qlrzjzl = "1";
                    break;
            }
        }
        //this.qlrzjzl = qlrzjzl;
    }

    public String getQlrlxdh() {
        return qlrlxdh;
    }

    public void setQlrlxdh(String qlrlxdh) {
        this.qlrlxdh = qlrlxdh;
    }

    public String getGyfs() {
        return gyfs;
    }

    public void setGyfs(String gyfs) {
        this.gyfs = gyfs;
    }

    public String getQlbl() {
        return qlbl;
    }

    public void setQlbl(String qlbl) {
        this.qlbl = qlbl;
    }

    public String getSxh() {
        return sxh;
    }

    public void setSxh(String sxh) {
        this.sxh = sxh;
    }

    public String getQlrzjmc() {
        return qlrzjmc;
    }

    public String getCqzh() {
        return cqzh;
    }

    public void setCqzh(String cqzh) {
        this.cqzh = cqzh;
    }

    public String getGyfsmc() {
        return gyfsmc;
    }

    public void setGyfsmc(String gyfsmc) {
        this.gyfsmc = gyfsmc;
    }

    public String getGyfsMc() {
        return gyfsMc;
    }

    public void setGyfsMc(String gyfsMc) {
        this.gyfsMc = gyfsMc;
    }

    public void setQlrzjmc(String qlrzjmc) {
        this.qlrzjmc = qlrzjmc;
    }

    public String getGybl() {
        return gybl;
    }

    public void setGybl(String gybl) {
        this.gybl = gybl;
    }

    public String getDjsj() {
        return djsj;
    }

    public void setDjsj(String djsj) {
        this.djsj = djsj;
    }

    public String getQlrzldm() {
        return qlrzldm;
    }

    public void setQlrzldm(String qlrzldm) {
        this.qlrzldm = qlrzldm;
    }

    public String getQlrzlmc() {
        return qlrzlmc;
    }

    public void setQlrzlmc(String qlrzlmc) {
        this.qlrzlmc = qlrzlmc;
    }

    public String getDyrfddbr() {
        return dyrfddbr;
    }

    public void setDyrfddbr(String dyrfddbr) {
        this.dyrfddbr = dyrfddbr;
    }

    public String getDyrfddbrlxdh() {
        return dyrfddbrlxdh;
    }

    public void setDyrfddbrlxdh(String dyrfddbrlxdh) {
        this.dyrfddbrlxdh = dyrfddbrlxdh;
    }

    public String getDyrfddbrzjzl() {
        return dyrfddbrzjzl;
    }

    public void setDyrfddbrzjzl(String dyrfddbrzjzl) {
        this.dyrfddbrzjzl = dyrfddbrzjzl;
    }

    public String getDyrfddbrzjzlmc() {
        return dyrfddbrzjzlmc;
    }

    public void setDyrfddbrzjzlmc(String dyrfddbrzjzlmc) {
        this.dyrfddbrzjzlmc = dyrfddbrzjzlmc;
    }

    public String getDyrfddbrzjh() {
        return dyrfddbrzjh;
    }

    public void setDyrfddbrzjh(String dyrfddbrzjh) {
        this.dyrfddbrzjh = dyrfddbrzjh;
    }

    public String getQlrtxdz() {
        return qlrtxdz;
    }

    public void setQlrtxdz(String qlrtxdz) {
        this.qlrtxdz = qlrtxdz;
    }

    public String getQlryb() {
        return qlryb;
    }

    public void setQlryb(String qlryb) {
        this.qlryb = qlryb;
    }

    public String getQlrdlr() {
        return qlrdlr;
    }

    public void setQlrdlr(String qlrdlr) {
        this.qlrdlr = qlrdlr;
    }

    public String getQlrdlrmc() {
        return qlrdlrmc;
    }

    public void setQlrdlrmc(String qlrdlrmc) {
        this.qlrdlrmc = qlrdlrmc;
    }

    public String getQlrdlrlxdh() {
        return qlrdlrlxdh;
    }

    public void setQlrdlrlxdh(String qlrdlrlxdh) {
        this.qlrdlrlxdh = qlrdlrlxdh;
    }

    public String getQlrdlrzjzl() {
        return qlrdlrzjzl;
    }

    public void setQlrdlrzjzl(String qlrdlrzjzl) {
        this.qlrdlrzjzl = qlrdlrzjzl;
    }

    public String getQlrdlrzjh() {
        return qlrdlrzjh;
    }

    public void setQlrdlrzjh(String qlrdlrzjh) {
        this.qlrdlrzjh = qlrdlrzjh;
    }

    public String getDyrtxdz() {
        return dyrtxdz;
    }

    public void setDyrtxdz(String dyrtxdz) {
        this.dyrtxdz = dyrtxdz;
    }

    public String getQlrmcTm() {
        return qlrmcTm;
    }

    public void setQlrmcTm(String qlrmcTm) {
        this.qlrmcTm = qlrmcTm;
    }

    public String getQlrzjhTm() {
        return qlrzjhTm;
    }

    public void setQlrzjhTm(String qlrzjhTm) {
        this.qlrzjhTm = qlrzjhTm;
    }

    public String getQlrfddbr() {
        return qlrfddbr;
    }

    public void setQlrfddbr(String qlrfddbr) {
        this.qlrfddbr = qlrfddbr;
    }

    public String getQlrfddbrzjzl() {
        return qlrfddbrzjzl;
    }

    public String getSfdzqzdm() {
        return sfdzqzdm;
    }

    public void setSfdzqzdm(String sfdzqzdm) {
        this.sfdzqzdm = sfdzqzdm;
    }

    public void setQlrfddbrzjzl(String qlrfddbrzjzl) {
        if (StringUtils.isBlank(qlrfddbrzjzl)) {
            this.qlrfddbrzjzlmc = "身份证";
            this.qlrfddbrzjzl = "1";
        } else if (qlrfddbrzjzl.matches("[0-9]+")) {
            //传数字
            this.qlrfddbrzjzl = qlrfddbrzjzl;
            switch (qlrfddbrzjzl) {
                case "2":
                    this.qlrfddbrzjzlmc = "港澳台身份证";
                    break;
                case "3":
                    this.qlrfddbrzjzlmc = "护照";
                    break;
                case "4":
                    this.qlrfddbrzjzlmc = "户口簿";
                    break;
                case "5":
                    this.qlrfddbrzjzlmc = "军官证（士兵证）";
                    break;
                case "6":
                    this.qlrfddbrzjzlmc = "组织机构代码";
                    break;
                case "7":
                    this.qlrfddbrzjzlmc = "营业执照";
                    break;
                case "8":
                    this.qlrfddbrzjzlmc = "统一社会信用代码";
                    break;
                case "9":
                    this.qlrfddbrzjzlmc = "外国人永久居留证";
                    break;
                case "99":
                    this.qlrfddbrzjzlmc = "其它";
                    break;
                case "1":
                default:
                    this.qlrfddbrzjzlmc = "身份证";
                    break;
            }
        } else {
            //传中文
            this.qlrfddbrzjzlmc = qlrfddbrzjzl;
            switch (qlrfddbrzjzl) {
                case "港澳台身份证":
                    this.qlrfddbrzjzl = "2";
                    break;
                case "护照":
                    this.qlrfddbrzjzl = "3";
                    break;
                case "户口簿":
                    this.qlrfddbrzjzl = "4";
                    break;
                case "军官证（士兵证）":
                    this.qlrfddbrzjzl = "5";
                    break;
                case "组织机构代码":
                    this.qlrfddbrzjzl = "6";
                    break;
                case "营业执照":
                    this.qlrfddbrzjzl = "7";
                    break;
                case "社会信用代码":
                case "统一社会信用代码":
                    this.qlrfddbrzjzl = "8";
                    break;
                case "外国人永久居留证":
                    this.qlrfddbrzjzl = "9";
                    break;
                case "其它":
                    this.qlrfddbrzjzl = "99";
                    break;
                case "身份证":
                default:
                    this.qlrfddbrzjzl = "1";
                    break;
            }
        }
    }

    public String getQlrfddbrzjzlmc() {
        return qlrfddbrzjzlmc;
    }

    /*public void setQlrfddbrzjzlmc(String qlrfddbrzjzlmc) {
        this.qlrfddbrzjzlmc = qlrfddbrzjzlmc;
    }*/

    public String getQlrfddbrzjh() {
        return qlrfddbrzjh;
    }

    public void setQlrfddbrzjh(String qlrfddbrzjh) {
        this.qlrfddbrzjh = qlrfddbrzjh;
    }
}
