package cn.gtmap.hlw.core.enums.jdxx;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/9/27
 * @description 资格审查
 */
@Getter
@AllArgsConstructor
public enum ZgscEnum {
    /**
     * 待生成
     */
    DSC("0", "待发起"),
    /**
     * 生成成功
     */
    SCSB("1", "发起成功"),
    /**
     * 生成失败
     */
    SCCG("2", "发起失败");


    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (ZgscEnum xq : ZgscEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
