package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
 * @version 1.0, 2025/3/27
 * @description 免收事项枚举
 */
@Getter
@AllArgsConstructor
public enum MssxEnum {
    MSSX_MS("1", "免收"),
    MSSX_JB("2", "减半"),
    MSSX_W("3", "无"),
    MSSX_YGMS("4", "预告免收"),
    MSSX_XWQY("5", "小微企业"),
    MSSX_TDJYXWQY("6", "土地交易（小微企业）");
    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (MssxEnum mssxEnum : MssxEnum.values()) {
            if (mssxEnum.code.equals(code)) {
                return mssxEnum.getMsg();
            }
        }
        return null;
    }
}
