package cn.gtmap.hlw.core.enums.api;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2024/11/29
 * @description 互联网提供给第三方API 状态码
 */
@Getter
@AllArgsConstructor
public enum ApiStatusCodeEnum {

    CODE_CG("0000", "成功"),

    CODE_CSWK("0001", "参数为空"),

    CODE_AESJMCW("0002", "AES加密错误"),

    CODE_TOKENWX("0003", "token无效"),

    CODE_CSCW("0004", "参数错误"),

    CODE_CXZXCW("0005", "程序执行出错"),

    CODE_SZQMBYZ("0006", "数字签名不一致"),

    CODE_JSONERROR("0007", "data参数为空或json转对象错误"),

    CODE_CSZDXSB("0008", "参数转对象失败"),

    CODE_OPENIDWK("0009", "微信openid为空"),

    CODE_LYYTOKENBYZ("0010", "来源与token来源不一致"),

    CODE_HQGXSJSB("0011", "获取共享数据失败"),

    CODE_RQGSBZQ("0012", "日期格式不正确"),

    CODE_ZDSJWK("0013", "字典数据为空"),

    CODE_SJCSSB("1000", "数据初始失败"),

    CODE_DMWZCW("2000", "代码未知错误"),

    CODE_TOKENCW("2010", "安全token错误");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (ApiStatusCodeEnum xq : ApiStatusCodeEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
