package cn.gtmap.hlw.core.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/8/25 11:22
 * @description JddmEnum
 */
@Getter
@AllArgsConstructor
public enum JddmEnum {

    /**
     * 授权云签
     */
    JDDM_BDJS_0("0", "发起授权云签"),
    /**
     * 报件申请
     */
    JDDM_BDJS_10("10", "报件申请"),
    /**
     * 草稿
     */
    JDDM_BDJS_1001("1001", "草稿"),
    /**
     * 申请提交
     */
    JDDM_BDJS_1002("1002", "申请提交"),
    /**
     * 附件生成
     */
    JDDM_BDJS_1003("1003", "附件生成"),
    /**
     * 双方核验
     */
    JDDM_BDJS_1004("1004", "双方核验"),
    /**
     * 交易材料双方确认（第一次云签）
     */
    JDDM_BDJS_1005("1005", "交易材料双方确认（第一次云签）"),

    /**
     * 税务
     */
    JDDM_BDJS_30("30", "税务"),
    /**
     * 资格审查
     */
    JDDM_BDJS_20("20", "资格审查"),
    /**
     * 发起网签备案
     */
    JDDM_BDJS_2001("2001", "发起网签备案"),
    /**
     * 获取网签备案结果
     */
    JDDM_BDJS_2002("2002", "获取网签备案结果"),
    /**
     * 交易合同双方确认（第二次云签）
     */
    JDDM_BDJS_2003("2003", "交易合同双方确认（第二次云签）"),
    /**
     * 税务核税
     */
    JDDM_BDJS_3001("3001", "税务核税"),
    /**
     * 获取税务申报单
     */
    JDDM_BDJS_3002("3002", "获取税务申报单"),
    /**
     * 双方确认申报
     */
    JDDM_BDJS_3003("3003", "双方确认申报（第三次云签）"),
    /**
     * 申报单上报
     */
    JDDM_BDJS_3004("3004", "申报单上报"),
    /**
     * 价格明细单
     */
    JDDM_BDJS_3005("3005", "价格明细单"),
    /**
     * 银行
     */
    JDDM_BDJS_40("40", "银行"),
    /**
     * 银行核验
     */
    JDDM_BDJS_4001("4001", "银行审查"),
    /**
     * 抵押合同双方确认
     */
    JDDM_BDJS_4002("4002", "抵押合同双方确认"),
    /**
     * 通知银行核验
     */
    JDDM_BDJS_4003("4003", "通知银行核验"),
    /**
     * 银行盖章
     */
    JDDM_BDJS_4004("4004", "银行盖章"),
    /**
     * 缴税缴费
     */
    JDDM_BDJS_50("50", "缴税缴费"),
    /**
     * 获取缴税明细
     */
    JDDM_BDJS_5001("5001", "获取缴税明细"),
    /**
     * 缴税
     */
    JDDM_BDJS_5002("5002", "缴税"),
    /**
     * 完税凭证
     */
    JDDM_BDJS_5003("5003", "完税凭证"),
    /**
     * 电子税票
     */
    JDDM_BDJS_5004("5004", "电子税票"),
    /**
     * 缴费
     */
    JDDM_BDJS_5005("5005", "缴费"),
    /**
     * 电子发票
     */
    JDDM_BDJS_5006("5006", "电子发票"),


    /**
     * 推送登记
     */
    JDDM_SH_TSDJ("6002", "推送登记"),

    /**
     * 登记审核
     */
    JDDM_SH_DJSH("6003", "登记审核"),

    /**
     * 登记登簿
     */
    JDDM_SH_DJDB("6004", "登记登簿"),

    /**
     * 登记领证
     */
    JDDM_SH_DJLZ("6005", "登记领证");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (JddmEnum xq : JddmEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }

    /**
     * 获取云签节点代码集合
     */
    public static List<String> getYqjddmList() {
        return Arrays.asList(JddmEnum.JDDM_BDJS_1005.getCode(), JddmEnum.JDDM_BDJS_2003.getCode(), JddmEnum.JDDM_BDJS_3003.getCode());
    }
}
