package cn.gtmap.hlw.core.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/2/22
 * @description
 */
@Getter
@AllArgsConstructor
public enum HfztEnum {
    /**
     * 恢复状态 - 未恢复
     */
    HFZT_WHF("0", "未恢复"),
    /**
     * 恢复状态-  已恢复
     */
    HFZT_YHF("1", "已恢复"),
    /**
     * 恢复状态-  恢复失败
     */
    HFZT_HFSB("2", "恢复失败");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (HfztEnum xq : HfztEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
