package cn.gtmap.hlw.core.enums;

import com.gtis.config.AppConfig;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author jianglin
 * @Date 2025/9/28
 * @Description 用于存储返回代码和信息
 */
public class CodeUtil {
    //特殊型（非法字符）
    public static final String ILLEGALCHARACTER = "1111";
    //特殊型（需要用户登录）
    public static final String NEEDLOGIN = "6666";
    //解密错误
    public static final String DECRYPTERROR = "4444";
    //没有权限
    public static final String NORIGHTHANDLE = "2333";
    //保存数据失败
    public static final String SAVEFAILED = "2334";
    //更新数据失败
    public static final String UPDATEFAILED = "2335";
    //删除数据失败
    public static final String DELETEFAILED = "2336";
    //自定义异常
    public static final String ZDYYC = "9999";
    //该功能正在开发中，请联系当地登记中心
    public static final String GNKFZ = "9998";

    /*--------------------CA校验型----------------------------*/
    //该CA已经绑定过
    public static final String CAHASEXISTS = "0201";
    //CA证书不存在
    public static final String CANOTEXISTS = "0202";
    //CA绑定部门和用户所在部门不一致
    public static final String CAORGNOTEQUALUSERORG = "0203";
    //CA绑定类型出错
    public static final String CABINDINGTYPEERROR = "0204";
    //该用户已经绑定过CA
    public static final String USERHASBINDCA = "0205";
    //证书密码错误，请检查！
    public static final String CAPASSWORDERROR = "0206";
    /*--------------------指纹校验型----------------------------*/
    //指纹不存在
    public static final String ZWNOTEXISTS = "0301";
    //指纹不匹配
    public static final String ZWNOMATCH = "0302";
    /*--------------------密码型----------------------------*/
    //密码过于简单
    public static final String EASYPWD = "0101";
    //原密码新密码相同
    public static final String NEWPWDEQUALSOLDPWD = "0102";
    //原密码错误
    public static final String YMMCW = "0103";
    //新密码与确认密码不一致
    public static final String XMMYQRMMBYZ = "0104";

    /*--------------------通用型----------------------------*/
    //成功
    public static final String SUCCESS = "0000";
    //参数为空
    public static final String PARAMNULL = "0001";
    //加密错误
    public static final String ENCRYPTERROR = "0002";
    //token验证失败
    public static final String TOKENINVALID = "0003";
    //参数错误
    public static final String PARAMERROR = "0004";
    //程序执行错误
    public static final String RUNERROR = "0005";
    //签名不一致
    public static final String SIGNDIFF = "0006";
    //data参数为空或json转对象错误
    public static final String DATANULLORCHANGEERROR = "0007";
    //参数转换对象失败
    public static final String CHANGEERROR = "0008";
    //微信openid为空
    public static final String OPENIDNULL = "0009";
    //传入来源与token不一致
    public static final String ORIGINDIFF = "0010";
    //获取共享数据失败
    public static final String GETPUBLICDATAFAIL = "0011";
    //日期格式不正确
    public static final String DATESTYLEERROR = "0012";
    //获取字典项为空
    public static final String ZDNULl = "0013";
    //获取token失败
    public static final String GETTOKENFAIL = "0014";
    //http链接状态（失败）
    public static final String HTTPLINKFAIL = "0015";

    //短信发送过频，请稍后再试
    public static final String FREQUENCYERROR = "0016";
    //视频保存出错
    public static final String VIDEOSAVEERROR = "0017";
    //音频保存出错
    public static final String AUDIOSAVEERROR = "0018";
    //密码复杂度低
    public static final String LOWPASSWORDCOMPLEXITY = "0019";
    //获取access_token失败
    public static final String GETACCESSTOKENFAILL = "0020";
    //access_token为空
    public static final String ACCESSTOKENISNULL = "0021";
    //access_token已过期
    public static final String ACCESSTOKENEXPIRED = "0022";
    //无效的access_token
    public static final String INVALIDACCESSTOKEN = "0023";
    //AppConfig配置不存在
    public static final String APPCONFIGNULL = "0024";
    //类型转换错误
    public static final String CLASSCASTFAILED = "0025";
    //资源不存在
    public static final String RESOURCENOTEXISTS = "0026";
    //资源非法
    public static final String RESOURCEILLEGAL = "0027";
    //未获取到资源
    public static final String GETRESOURCENULL = "0028";
    //无权新建角色
    public static final String NORIGHTCREATEROLE = "0031";
    //无权新建组织
    public static final String NORIGHTCREATEORGANIZE = "0032";
    //无权操作用户
    public static final String NORIGHTCREATEUSER = "0033";
    //角色非法
    public static final String ROLEILLEGAL = "0034";
    //部门非法
    public static final String ORGANIZEILLEGAL = "0035";
    //不可删除管理角色
    public static final String ROLECANNOTDELETE = "0036";
    //请求用户ID或者被操作人ID为空
    public static final String REQUSERIDORBEOPERATEUSERIDNULL = "0037";
    //角色已经存在
    public static final String ROLEEXISTS = "0038";
    //部门已经存在
    public static final String ORGANIZEEXISTS = "0039";
    //部门不存在
    public static final String ORGANIZENOTEXISTS = "0040";
    //角色不存在
    public static final String ROLENOTEXISTS = "0041";
    //不能以自己部门为父部门
    public static final String CANNOTBEPARENTASSELF = "0042";
    //新建部门时必须选择父部门
    public static final String MUSTCHOOSEPARENTORGID = "0043";
    //获取部门信息失败
    public static final String GETORGANIZEINFOFAILL = "0044";
    //请用CA登录
    public static final String MUSTCALOGIN = "0045";
    //资源菜单不合法
    public static final String FUNCTIONMENUILLEGAL = "0046";
    //数据可见范围字典项非法
    public static final String DATASCOPEILLEGAL = "0047";
    //微信openID已存在
    public static final String OPENIDEXISTS = "0048";
    //真实姓名为空
    public static final String REALNAMENULL = "0049";

    //数据已存在
    public static final String SJEXISTS = "0050";


    //该人员新增窗口和登记中心与历史数据不一致
    public static final String USERDJZXERROR = "0051";

    //不动产权证号参数为空
    public static final String BDCQZHNULL = "0052";

    //不动产单元编号参数为空
    public static final String BDCDYBHNULL = "0053";
    //不动产单元号参数为空
    public static final String BDCDYHNULL = "0054";
    //项目id参数为空
    public static final String XMIDNULL = "0055";
    //字典新闻类型资源不存在
    public static final String ZDXWLXSOURCENOTEXIST = "0090";

    /**
     * 第三方接口执行失败
     */
    public static final String THIRD_INTERFACE_EXECUTE_FAILED = "0056";

    /**
     * 高拍仪开启失败
     */
    public static final String HIGH_PHOTO_OPEN_FAILED = "0057";

    /**
     * serviceId参数错误
     */
    public static final String SERVICEID_ERROR = "0058";

    /**
     * 完税信息无法撤销
     */
    public static final String UNABLE_REVOKE = "0059";

    /**
     * 完税信息无法撤销
     */
    public static final String CANCEL_TAXATION_DECLARE_FAILED = "0060";

    //法人名称已经存在
    public static final String ORGANIZENAMEEXISTS = "0062";

    //法人证件号已经存在
    public static final String ORGANIZEZJIDEXISTS = "0063";

    //用户名或证件号输入有误
    public static final String NAMEORZJIDERROR = "0064";

    /**
     * 打印失败
     */
    public static final String PRINT_FAILED = "0061";

    /**
     * 展示失败
     */
    public static final String SHOW_FAILED = "00610";

    /**
     * 网络异常，请稍后再试
     */
    public static final String NETWORK_EXCEPTION = "0065";

    //请用指纹登录
    public static final String MUSTZWLOGIN = "0066";

    //因恶意攻击已被禁用
    public static final String MALICIOUSATTACKS = "0067";

    /*-------------------登录模块-------------------------*/
    //用户名为空
    public static final String USERNAMENULL = "1001";
    //密码为空
    public static final String PWDNULL = "1002";
    //无该登录名
    public static final String USERNAMENONE = "1003";
    public static final String QLRUSERNAMENONE = "10031";

    public static final String JSUSORDINARYUSERCANLOGIN = "10036";

    // 已婚人员家庭成员必填
    public static final String QLRJTCYNULL = "10032";
    public static final String QLRJTCYGXMCNULL = "10033";
    public static final String QLRJTCYMCZJHNULL = "10034";
    public static final String QLRJTCYGXNULL = "10035";

    //婚姻状态校验错误
    public static final String HYZTCHECKERROR = "10037";
    //房屋套次校验错误
    public static final String FWTCCHECKERROR = "10038";

    //密码错误
    public static final String PWDERROR = "1004";
    //电话号码为空
    public static final String PHONENULL = "1005";
    //证件种类或证件号为空
    public static final String ZJNUll = "1006";
    //角色为空
    public static final String ROLENUll = "1007";
    //登录名已存在
    public static final String LOGINNAMEEXIST = "1008";
    //证件号已存在
    public static final String ZJHEXIST = "1009";
    //不存在该用户
    public static final String USERNOTEXIST = "1010";
    //登录名和密码不为空
    public static final String NAMEANDPWDNULL = "1011";
    //电话号码已存在
    public static final String PHONEEXIST = "1012";
    //该登录名有多个用户，请联系管理员
    public static final String USERMOREEXIST = "1013";
    //判断用户是否被禁用
    public static final String DISABLE = "1014";
    //上传身份证和登陆用户信息不匹配
    public static final String IDCARDNOTRIGHT = "1015";
    //用户或邮箱不存在
    public static final String USEROREMAILNOTEXIST = "1016";
    //用户不为管理员
    public static final String USERNOTADMIN = "1017";
    //密码输入错误次数过多
    public static final String PWDERRORCOUNTLIMIT = "1018";
    //角色必须是普通用户
    public static final String ROLEMUSTBEUSER = "1019";
    //用户名密码错误
    public static final String USERNAMEPWDERROR = "1020";
    //用户名已存在
    public static final String USERNAMEEXIST = "1021";
    //用户GUID为空
    public static final String USERGUIDISNULL = "1022";
    //登陆验证码错误
    public static final String LOGINYZMERROR = "1023";
    //保存用户失败
    public static final String SAVEUSERFAILED = "1024";
    //机构名称已存在
    public static final String JGNAMEEXISTS = "1025";
    //获取用户信息失败
    public static final String GETUSERINFOFAILL = "1026";
    //合肥CA认证失败
    public static final String CACERTIFYFAILED = "1027";
    //用户角色信息为空
    public static final String USERROLENULL = "1028";
    //只需要数字或者字母
    //public static final String NUMORLETTER = "1029";
    /*//需要字母和数字
    public static final String NUMANDLETTER = "1030";
    //需要大写字母且小写字母和数字
    public static final String NUMAaLETTER = "1031";
    //需要大写字母、小写字母、数字和符号
    public static final String NUMANDMARK = "1032";*/

    public static final String NUMORLETTER = "1029";
    public static final String NUMANDLETTER = "1030";
    public static final String NUMAaLETTER = "1031";
    public static final String NUMAaLETTERLENGTH = "1032";
    public static final String NUMANDMARKTHREE = "1033";
    public static final String NUMANDMARK = "1034";
    public static final String NUMANDMARKLENGTH = "1035";
//0        六位长度以上的密码，数字或者字母。（范围：数字、字母）
//1        八位长度以上的密码，必须包含数字和字母。（范围：数字、字母）
//2        八位长度以上的密码，必须包含数字、大写字母和小写字母。（范围：数字、字母）
//3        8`20位长度的密码，必须包含数字，大小写字母。（范围：数字、字母）
//4        八位长度以上的密码，必须包含数字、大写字母、小写字母和特殊字符(四种中任三种)。（范围：数字、字母、特殊字符）
//5        八位长度以上的密码，必须包含数字、大写字母、小写字母和特殊字符。（范围：数字、字母、特殊字符）
//6        8`16位长度的密码，必须包含数字、大写字母、小写字母和特殊字符。（范围：数字、字母、特殊字符）

    //登录密码到期,无法登陆系统,请您修改密码之后登录
    public static final String PWDERRORYXQ = "1036";
    public static final String OTHERCLIENTALREADYLOGIN = "10039";
    //传入用户信息和AccessToken不匹配
    public static final String USERINFONOTRIGHT = "1037";
    //大庆 用户锁定
    public static final String DQUSERLOCKED = "1038";
    //用户名密码错误，请重新修改用户信息
    public static final String USERNAMEPWDERRORMESSAGE = "1039";
    //用户未注册，请先注册
    public static final String USERNOREGISTERERRORMESSAGE = "1040";
    //常州 用户名或密码错误次数过多
    public static final String CZUSERLOCKED = "1041";
    /*=----------------------申请模块-----------------------*/
    //未查询到数据
    public static final String RESULTNONE = "2001";
    //申请信息为空
    public static final String SQXXNULL = "2002";
    //申请信息受理编号不为空
    public static final String SQXXSLBHNULL = "20021";
    //申请信息申请类型不为空
    public static final String SQXXSQLXNULL = "20022";
    //不动产类型不为空
    public static final String SQXXBDCLXNULL = "20023";
    //创建用户不为空或者不存在
    public static final String SQXXCREATEUSERNULLORNOTEXIST = "20024";
    //管理员不允许创建申请信息
    public static final String SQXXCREATEBYADMIN = "20025";
    //申请信息证书号为空
    public static final String SQXXZSHNULL = "20026";
    //申请信息坐落为空
    public static final String SQXXZLNULL = "20027";
    //申请信息不动产单元号为空
    public static final String SQXXBDCDYHNULL = "20028";
    //申请信息面积为空
    public static final String SQXXMJNULL = "20029";
    //申请信息不动产单元号为空
    public static final String SQXXFCZHNULL = "20030";
    //该不动产权证号已经创建过信息
    public static final String SQXXCQZHEXIST = "200301";
    //该不动产单元号已经创建过信息
    public static final String SQXXBDCDYHEXIST = "200302";
    //该买卖合同号已经创建过信息
    public static final String SQXXMMHTHEXIST = "200303";
    //申请信息更新主键为空
    public static final String SQXXIDNULL = "200210";
    //不存在该申请信息
    public static final String SQXXNOTEXIST = "200211";
    //存在该申请信息
    public static final String SQXXEXIST = "200212";
    //登记系统查询异常
    public static final String DJXTCXYC = "200213";
    //登记系统查询TOKEN错误
    public static final String DJXTTOKENCW = "200214";
    //银行抵押推送失败
    public static final String BANKDYTSFAILL = "200215";
    //查封状态下不允许抵押
    public static final String CFZTCANNOTDY = "200216";
    //查封状态下不允许
    public static final String CFZTCANNOT = "200217";
    //抵押状态下不允许
    public static final String DYZTCANNOT = "200218";
    //买卖合同编号不允许为空
    public static final String SQXXMMHTHNULL = "200219";
    // 证书来源不能为空
    public static final String SQXXZSLYNULL = "200220";
    //抵押证明号不允许为空
    public static final String SQXXDYZMHNULL = "200221";
    //申请信息更新失败
    public static final String SQXXUPDATEFAILL = "200222";
    //抵押证明号不是当前用户,请联系业务管理员,线下办理
    public static final String SQXXDYZMHERROR = "200223";
    //提交申请信息失败，请联系管理员后再次提交
    public static final String SQXXTJSBQLXGLY = "200224";
    //该抵押证明已经存在
    public static final String SQXXDYZMHEXIST = "200225";
    //产权证不匹配
    public static final String ZSNOTMATCH = "200226";
    //申请类型不存在
    public static final String SQXXSQLXNOTEXIST = "200227";
    //申请不可撤回
    public static final String SQXXCANNOTRECALL = "200228";
    //申请不可删除
    public static final String SQXXCANNOTDELETE = "200229";
    //受理状态异常
    public static final String SQXXSLZTABNORMAL = "200230";
    //申请不可补录附件
    public static final String SQXXCANNOTSUPPLYFJ = "200231";
    //该合同存在查封或抵押信息，请重新确认
    public static final String HTHISEXIST = "200232";
    //业务系统受理编号为空
    public static final String YWXTSLBHNOTEXIST = "200233";
    //请用本人或本部门用户登陆查询
    public static final String QUERYBYMINE = "200234";
    //该业务需到线下窗口办理
    public static final String SQXXXXBL = "200235";
    //不存在印制号
    public static final String QZYSXLHISNULL = "200236";
    //自动办结失败
    public static final String AUTOFINISHFAIL = "200237";
    //受理编号生成失败
    public static final String SQXXSLBHERROR = "200238";
    //办件已推送登记
    public static final String SQXXYTSDJ = "200239";
    //权利人为空
    public static final String QLRNULL = "2003";
    //权利人名称为空
    public static final String QLRMCNULL = "20031";
    //权利人证件种类为空
    public static final String QLRZJZLNULL = "20032";
    //权利人证件号为空
    public static final String QLRZJHNULL = "20033";
    //权利人更新主键为空
    public static final String QLRIDNULL = "20034";
    //权利人更新sqid为空
    public static final String QLRSQIDNULL = "20035";
    //权利人和用户不匹配
    public static final String QLRUSERNOTMATCH = "20036";
    //权利人权利比例不匹配
    public static final String QLRQLBLERROR = "20037";
    //义务人权利比例不匹配
    public static final String YWRQLBLERROR = "20038";
    //权利人与义务人相同
    public static final String QLRYWRXT = "20039";
    //权利人名称证件号验证失败
    public static final String QLRYZERROR = "20040";


    //附件项目为空
    public static final String FJXMNULL = "2004";
    //附件数据为空
    public static final String FJDATANULL = "20041";
    //附件项目中附件类型不能为空
    public static final String FJXMFJLXNULL = "20042";
    //申请信息 -- 为查询到会签数据
    public static final String QUERYSQXXHQDATAFAILL = "20043";
    //申请信息 -- 存在未核验用户
    public static final String HASUSERISNOTVERIFICATION = "20044";

    //共有方式错误，请重新核验
    public static final String QLRGYFSERROR = "20045";
    //该不动产单元已核税
    public static final String BDCDYHISTAXVERIFY = "20046";

    /**
     * 授权码不存在
     */
    public static final String SQMBCZ = "20047";

    /**
     * 授权码已过期
     */
    public static final String SQMYGQ = "20048";

    //附件信息为空
    public static final String FJXXNULL = "2005";
    //附件图片流不能为空
    public static final String FJXXPICNULL = "20051";
    //附件名称不能为空
    public static final String FJXXFILEMCNULL = "20052";
    //附件上传人不能为空
    public static final String FJXXCREATEUSERNULL = "20053";
    //附件图片保存失败
    public static final String FJXXPICSAVEERROR = "20054";
    //附件大小超过限制20070
    public static final String FJOVERLIMIT = "20070";
    //附件类型为空
    public static final String FJTYPEISNULL = "20100";
    //附件不支持该申请类型
    public static final String FJISNOTSUPORTTHISTYPE = "20101";
    //附件不合格
    public static final String FJTYPEWRONGFUL = "20102";
    //申请信息需要预审但是尚未预审通过
    public static final String SQXXNEEDVERIFYBUTNOTPASS = "200103";
    //当前件非线上办件，不能打印收件单
    public static final String NOTXSBJ = "200104";
    /**
     * 未完成视频公证
     */
    public static final String WWCSPGZ = "200105";
    //未挂牌
    public static final String WGP = "200106";
    //存在租赁
    public static final String EXISTZL = "200107";
    //互联网正在办理查封
    public static final String HLWZZBLCF = "200108";
    /*=----------------------EXCEL上传模块-----------------------*/
    public static final String EXCELERROR = "20055";

    //问询笔录答案不能为空
    public static final String SQXXWXBLDAISERROR = "20056";
    //问询笔录录入失败
    public static final String SQXXWXBLINSERTFAILL = "20057";
    //题库查询失败或不存在该题库
    public static final String TKSELECTFAILORNOTEXIST = "20058";
    //问询笔录录入异常
    public static final String SQXXWXBLTHROWENTRYEXCEPTION = "20059";
    //更新人脸识别认证状态失败
    public static final String UPDATERLSBRZFAILL = "20060";
    //共有方式选择有误
    public static final String GYFSERROR = "200600";

    /*=----------------------预约模块-----------------------*/
    //预约信息不存在
    public static final String YYXXNOTEXIST = "2006";
    //预约创建人为空（yyrbs）
    public static final String YYXXCREATEUSERNULL = "20061";
    //预约人名称为空
    public static final String YYXXYYRMCNULL = "20062";
    //预约人证件号为空
    public static final String YYXXYYRZJHNULL = "20063";
    //预约人联系电话为空
    public static final String YYXXYYRLXDHNULL = "20064";
    //预约登记中心为空
    public static final String YYXXYYDJZXNULL = "20065";
    //预约登记中心不存在
    public static final String YYXXYYDJZXNOTEXIST = "20066";
    //预约时段为空
    public static final String YYXXYYSDNULL = "20067";
    //预约时段不存在
    public static final String YYXXYYSDNOTEXIST = "20068";
    //预约登记类型为空
    public static final String YYXXYYDJLXNULL = "20069";
    //预约登记类型不存在
    public static final String YYXXYYDJLXNOTEXIST = "200610";
    //预约来源不为空
    public static final String YYXXYYLYNULL = "200611";
    //该用户当天已预约，不可再预约
    public static final String YYXXYYNUMLIMIT = "200612";
    //该用户该预约时段已有该登记类型预约，不可再预约
    public static final String YYXXYYEXIST = "200613";
    //因用户最近15天内取消次数达到上限，所以从最后一次取消预约时间后30天无法预约
    public static final String YYXXYYNUMLIMITBYDAY = "200614";
    //预约创建人不存在
    public static final String YYXXCREATEUSERNOTEXIST = "200615";
    //预约时间为空
    public static final String YYXXYYSJNULL = "200616";
    //当天预约取消次数达到上限
    public static final String YYXXCANCELTIMELIMIT = "200617";
    //已存在预约信息
    public static final String YYXXEXIST = "200618";
    //预约时间为节假日
    public static final String YYSJJJR = "200619";
    //获取日期失败
    public static final String GETDATEFAIL = "200620";
    //预约时段已满
    public static final String YYSDFULL = "200621";
    //预约发生错误，刷新页面
    public static final String YYERROR = "200622";
    //不可以预约当天
    public static final String CONTYYTODAY = "200623";
    //预约部门代码不存在
    public static final String YYBMDMISNULL = "200624";
    // 预约黑名单
    public static final String YYHMD = "200625";
    //预约申请类型为空
    public static final String YYXXYYSQLXNULL = "200626";
    //一周内有效预约不可超过两次
    public static final String CONTYYTOWEEEK = "200627";
    //该手机号当天已有预约，请重新选择
    public static final String HASYYTODAY = "200628";
    //当前预约日期发生错误
    public static final String YYSJERROR = "200629";
    //当前预约时段最多只能预约一次，请您选择其他预约时段预约
    public static final String YYSDERROR = "200630";

    /*=----------------------缴费模块-----------------------*/
    //获取不到缴费信息
    public static final String JFXXNULL = "20071";
    //该缴费项存在有效的订单信息，无法创建新的订单信息
    public static final String ACTIVEJFXXEXIST = "20072";
    //生成订单失败
    public static final String GENERATEDDXXFAIL = "20073";
    //商户信息为空
    public static final String SHINFONULL = "20074";
    //缴费成功后的通知地址为空
    public static final String PAYREQUESTURLNULL = "20075";
    //订单参数为空
    public static final String DDPARAMNULL = "20076";
    //验证签名不通过
    public static final String SIGNERROR = "20077";
    //支付请求失败
    public static final String PAYREQUESTERROR = "20078";
    //付费方式为空
    public static final String FFFSNULL = "20079";
    //付费方式错误
    public static final String FFFSERROR = "200710";
    //支付方式为空
    public static final String ZFFSNULL = "200711";
    //支付方式错误
    public static final String ZFFSERROR = "200712";
    //订单不存在
    public static final String DDNOTEXIST = "200713";
    //订单金额需大于0
    public static final String DDJEERROR = "200714";
    //该用户无相关银行卡信息
    public static final String YHKNOTEXIST = "200715";
    //银行卡信息为空
    public static final String YHKINFONULL = "200716";
    //银行卡已绑定，不可绑定多个账户
    public static final String YHKYBD = "200718";
    //绑定银行卡失败
    public static final String YHKBDFAIL = "200719";
    //支付密码错误
    public static final String PAYPWDERROR = "200720";
    //支付失败
    public static final String PAYFAILED = "200721";
    //银行卡解绑失败
    public static final String YHKJBFAIL = "200722";
    //订单已缴费无法关闭
    public static final String DDNOTCLOSE = "200717";
    //有未缴费且激活的订单
    public static final String WJFACTIVEDD = "200723";
    //订单未支付成功
    public static final String DDNOTPAY = "200724";
    //缴费信息推送失败
    public static final String TRANSERROR = "200725";
    //缴费项无法完成缴费
    public static final String SFXMERROR = "200726";
    //无此受理编号的缴费信息
    public static final String SLBHNOTEXIST = "200727";
    //取消关闭订单错误
    public static final String QXZFGBDDERROR = "200728";
    //退款失败
    public static final String REFUNDFAILED = "200730";
    //不存在退款信息
    public static final String REFUNDNOTEXIST = "200732";
    //合计金额错误
    public static final String HJJEERROR = "200731";
    //缴费--未获取到税务信息
    public static final String JF_WHQDSWXX = "200733";
    //缴费--获取税务信息一次
    public static final String JF_HQSWXXYC = "200734";
    //缴费--未获取到税务信息明细
    public static final String JF_WHQDSWXXMX = "200735";

    //查询退款信息出错
    public static final String REFUNDRESULTFALL = "200736";

    //缴费--查询未转开的税款信息为空
    public static final String JF_CXWZKSKWK = "200737";

    //查询退款信息出错
    public static final String NORIGHT = "2007361";

    //缴费--未获取到税务信息
    public static final String JF_WCXDJFRXX = "200740";
    //纳税人识别号为空
    public static final String NSRSBHNULL = "200741";
    //推送税务失败
    public static final String TSSWXXFAIL = "200742";
    //尚未获取税款明细，请等待
    public static final String HQSKMXSB = "200743";
    //尚未获取三要素，请等待
    public static final String HQSWSYSSB = "200744";
    //缴款单作废失败
    public static final String JKDZFSB = "200745";
    //已缴费，删除/撤销申请需先进行退款
    public static final String YJFBKYSC = "200746";
    //已缴费，退回修改需先进行退费
    public static final String YJFBKYTHXG = "200747";
    //已缴税，退回修改需先进行退款
    public static final String YJSBKYTHXG = "200748";
    //已缴费，已缴税，退回修改需先进行退款
    public static final String YJSFBKYTHXG = "200749";

    /*=----------------------验证码模块-----------------------*/
    //验证码错误
    public static final String YZMERROR = "20081";
    //短信发送发生错误
    public static final String SMSSENDERROR = "20082";

    //证书查询受理编号为空
    public static final String ZSSLBHNULL = "20091";
    //证书查询输入的权利人与扫描结果不一致
    public static final String ZSQLRERROR = "20092";

    //该产权未落宗或未匹配不动产单元号，请至中心落宗或者匹配不动产单元号
    public static final String BDCDYHBYGDZHNULL = "20094";
    //该产权匹配多个不动产单元号
    public static final String BDCDYHBYGDZHERROR = "20095";

    /*=----------------------档案查询模块-----------------------*/
    //存在未审核档案信息
    public static final String WSHDAXXEXIST = "20093";

    /*=----------------------OCR身份识别模块-----------------------*/
    public static final String IDENTITYNOTMATCH = "30009";
    public static final String IDENTITYVALIDEERROR = "30008";

    /*=----------------------人脸核身模块-----------------------*/
    //活体检测失败
    public static final String LIVEDETECTFAIL = "110001";
    //人脸比对失败
    public static final String FACECOMPAREFAIL = "110002";
    //人脸对比阈值过低
    public static final String LIVEDETECTTHRESHOLDLOW = "110003";
    //人脸请求验证结果（轮询调接口查询结果）,无结果（无对应的session）
    public static final String LIVEDETECTRESULTNONE = "110004";
    //人脸查询二维码失效
    public static final String LIVEDETECTTIMEOUT = "110005";
    //人脸查询二维码轮询结果为空，继续轮询
    public static final String LIVEDETECTRESULTEMPTY = "110006";
    //人脸核身已经验证成功
    public static final String LIVEDETECTSUCCESS = "110007";
    //人脸核身业务类型为空
    public static final String LIVEDETECTYWLXNONE = "110008";
    //人脸核身验证超过使用限制
    public static final String LIVEDETECTCOUNTLIMIT = "110009";
    //阿里的人脸请求错误
    public static final String ALIPAYREQUESTFAIL = "110010";
    //阿里的人脸认证查询结果不正确
    public static final String ALIPAYQUERYFAIL = "110011";
    //阿里的身份信息未认证
    public static final String ALIPAYUSERINFONOTCERTIFIED = "110012";
    //不支持个人以外的用户类型
    public static final String ALIPAYUSERTYPENOTSUPPORT = "110013";

    /*=----------------------哈尔滨政务服务模块-----------------------*/
    //获取用户信息失败，需要重定向
    public static final String NEEDREDIRECT = "12001";
    //政务一张网用户ID缺失
    public static final String ONEMAPIDNOTEXIST = "12002";
    //政务网个人数据必须实名认证
    public static final String PERSONMUSTVERIFY = "12003";
    //需要重新选择企业类型
    public static final String NEEDCHOOSEORGANIZE = "12004";
    //请勿重复发起登录请求
    public static final String QWCFFQDLQQ = "12005";
    //改手机号码已被占用
    public static final String GSJHMYBZY = "12006";


    /*=----------------------服务网点查询模块-----------------------*/
    //服务网点信息不存在
    public static final String FWWDNOTEXIT = "20010";

    /*=----------------------服务评价模块-----------------------*/
    //服务已被评价过
    public static final String SERVEEVALUATED = "210001";
    /*=----------------------微信模板消息推送-----------------------*/
    //微信公众号通知信息推送失败
    public static final String WECHATTEMPLATEPUSHFAIL = "220001";
    //微信公众号信息通知模板id为空
    public static final String WECHATTEMPLATEIDISEMPTY = "220002";
    //微信公众号信息通知模板内容为空
    public static final String WECHATTEMPLATEDATAISEMPTY = "220003";


    /*=----------------------视频问询模块-----------------------*/
    //
    public static final String SPWXSMIDNULL = "230001";
    public static final String SPWXSMSMRNULL = "230002";
    public static final String SQLXNUll = "230003";
    public static final String SPWXYYNUll = "230004";
    /*=----------------------申请类型模块-----------------------*/
    public static final String SQLXPKNUll = "240001";

    /*=----------------------字典模块-----------------------*/
    public static final String SQLXEXIST = "250001";
    //CA字典项非法
    public static final String CAZDILLEGAL = "250002";
    //字典项非法
    public static final String ZDILLEGAL = "250003";

    /*=----------------------public模块-----------------------*/
    //public创建申请失败
    public static final String TRANSPUBLICSQXXFAILED = "260010";
    //public附件接受失败
    public static final String TRANSPUBLICFJXXFAILED = "260011";

    /*=----------------------一窗受理模块-----------------------*/
    public static final String ACCEPTANCEBUILDFAILED = "260001";
    public static final String ACCEPTANCETRANSFJFAILED = "260002";

    /*=----------------------一窗受理模块-----------------------*/
    public static final String UCUSERINFOFAILED = "270001";

    /*=----------------------一我的盐城App模块-----------------------*/
    //获取initCode失败
    public static final String MYYCAPPGETINITCODEFAILED = "28001";
    //获取authCode失败
    public static final String MYYCAPPGETAUTHCODEFAILED = "28002";
    //获取AccessToken失败
    public static final String MYYCAPPGETACCESSTOKENFAILED = "28003";
    //获取userAccessToken失败
    public static final String MYYCAPPGETUSERACCESSTOKENFAILED = "28004";
    //获取userInfo失败
    public static final String MYYCAPPGETUSERINFOFAILED = "28005";

    /*=----------------------一微信快捷登录模块-----------------------*/
    //微信快捷登录失败
    public static final String WECHATQUICKLOGINFAILED = "29001";
    //微信快捷登录是需要补充身份信息
    public static final String WECHATQUICKLOGINNEEDSUPPLEMENT = "29002";

    /*=----------------------一江苏政务网模块-----------------------*/
    //获取ticket失败
    public static final String VERIFYJSZWTICKETFAILED = "30001";
    //获取token失败
    public static final String VERIFYJSZWTOKENFAILED = "30002";
    //获取政务网用户信息失败
    public static final String GETZWWUSERFAILED = "30003";
    //不支持法人快捷登录系统
    public static final String NOTSUPPORTCORPORATIONQUICKLOGIN = "30004";

    /*=----------------------查询他人权利信息-----------------------*/
    //查询他人权利信息次数超限
    public static final String CXTRQLXXCSCX = "40001";
    //查询他人权利信息产权证号长度不足
    public static final String CXTRQLXXCQZHLENGTH = "40002";
    /*=----------------------公示公告-----------------------*/
    //公示公告信息推送门户网站失败
    public static final String GSGGXXTSMHWZYC = "50001";

    /*=----------------------查询模块-----------------------*/
    public static final String FHXXZDY = "60001";
    public static final String HTXXNONE = "60002";
    public static final String FWXXNONE = "60003";
    public static final String FWXXYBL = "60004";
    public static final String HTHNONE = "60005";

    /*=---------------------一卡清系统-----------------------------*/
    //获取一卡清系统缴费明细失败
    public static final String YKQHQJFMXSB = "61001";
    //一卡清系统生成订单失败
    public static final String YKQSCDDSB = "61002";
    //一卡清系统查询订单信息失败
    public static final String YKQCXDDSB = "61003";
    //一卡清请求登记3.0，获取缴费明细，返回数据出问题
    public static final String YKQHQDJ3JFMX = "61004";
    //一卡清请求登记2.0，获取缴费明细，返回数据出问题
    public static final String YKQHQDJ2JFMX = "61005";
    //一卡清获取对账单失败
    public static final String YKQHQDZDSB = "61006";
    //一卡清 该月结单号已经执行过批量开单
    public static final String YKQPLKDEXIST = "61007";
    //一卡清 已生成过月结单号
    public static final String YKQYJDHEXIST = "61008";
    //一卡清 卖方先缴税
    public static final String YKQMFJS = "61009";
    //POS机终端绑定失败
    public static final String YKQPOSBDSB = "610010";
    //POS机终端绑定失败，pos已绑定
    public static final String YKQPOSBDSB_YBD = "610011";
    /*=----------------------部门权限到期----------------------------*/
    //部门权限到期，不允许部门下用户登录
    public static final String BMQXDQ = "70001";

    /*=----------------------外部系统查询次数----------------------------*/
    //当日查询次数已达上限，请明日再试
    public static final String CXCSR = "80001";
    //当月查询次数已达上限，请下月再试，或者联系管理员
    public static final String CXCSY = "80002";
    //当年查询次数已达上限，请明日再试
    public static final String CXCSN = "80003";
    public static final String CXCSZ = "80004";

    /*--------------------无为查询证书-----------------------------*/
    //接口参数为空或处理异常
    public static final String ZSCODEZERO = "80100";
    //印制号不存在或被删除
    public static final String ZSCODEONE = "80101";
    //印制号存在，但是已经被使用
    public static final String ZSCODETWO = "80102";
    //印制号存在、未使用，但是该印制号不在当前用户权限下
    public static final String ZSCODETHREE = "80103";
    //印制号存在、未使用，且在当前用户名下，可使用
    public static final String ZSCODEFOUR = "80104";
    //该证书已经在登记系统打证
    public static final String ZSCODEFIVE = "80105";

    /*--------------------无为自动办结----------------------------*/
    //请先完成发证记录信息保存、打印操作
    public static final String WDYFZJL = "80106";
    //请先完成收费单信息保存、打印操作
    public static final String WDYSFD = "80107";

    //蚌埠合同备案信息撤销失败
    public static final String BAHTXXCXSB = "80108";

    //蚌埠一卡清相关异常
    //请先完成一卡清缴费或一窗受理操作
    public static final String QXWCYKQJFORYCSL = "80109";
    //暂无登记费明细，请耐心等待
    public static final String ZWDJFMX = "80110";
    //暂无税款明细，请耐心等待
    public static final String ZWSKMX = "80111";
    //费缴纳已完成，无法进行线上驳回
    public static final String YJFWFBH = "80112";
    //请确认是否已完成缴费缴库操作！
    public static final String QRSFWCYJK = "80113";
    //税款明细买卖双方未确认，请耐心等待
    public static final String SKMXSFWQR = "80114";
    //退款申请成功，请查询退款状态！
    public static final String QCXTKZT = "80115";
    //手机号码比对失败
    public static final String SJHMBDSB = "80116";
    //未获取到三要素信息
    public static final String SYSXXWHQ = "80117";
    //获取三要素信息不全
    public static final String SYSXXBQ = "80118";
    /*--------------------泰州非税系统与一卡清相关-----------*/
    //非税系统无响应
    public static final String FSXTWXY = "80200";
    //一卡清非税系统交互相关配置未添加
    public static final String FSXTPZCW = "80201";
    //获取执收单位信息失败
    public static final String HQZSDWXXSB = "80202";
    //获取缴费项目信息失败
    public static final String HQJFXMXXSB = "80203";
    //获取收费账户信息失败
    public static final String HQSFZHXXSB = "80204";
    //生成电子缴款单失败
    public static final String SCDZJKDSB = "80205";
    //查询应缴信息失败
    public static final String CXYJXXSB = "80206";
    //非税系统响应信息中无相关数据
    public static final String FSXTWXGSJ = "80207";
    //获取电子票据号码失败
    public static final String HQDZPJHMSB = "80208";
    //换开电子票据失败
    public static final String HKDZPJSB = "80209";
    //电子票据下载失败
    public static final String DZPJXZSB = "80210";
    //请求一卡清，获取电子票据信息失败
    public static final String HQDZPJXXSB = "80211";

    //客体信息查询超出限制
    public static final String KTXXCXCCXZ = "80212";

    //江苏省房地产交易税收一体化平台无响应
    public static final String JSSFDCJYSSYTHPTWXY = "80213";
    //房产交易申报信息确认失败
    public static final String FCJYSBXXQRSB = "80214";

    //市大数据局不动产登记信息查询失败
    public static final String SDSJBDCDJXXCXSB = "80215";
    //电子票据未生成 财政
    public static final String CZDZPJWSC = "80216";
    //目录名称已存在
    public static final String MLMCEXISTS = "80217";
    //政务网注册失败
    public static final String ZWFREGISTERERROR = "80218";


    /**
     * 缴费接口连接超时
     */
    public static final String CONNECTTIMEOUT = "80219";

    //请先进行统一认证
    public static final String QXJXTYRZ = "80220";

    /**
     * 推送失败，该不动产单元存在抵押
     */
    public static final String BDCCZDY = "80221";

    //获取上级目录失败
    public static final String HQSJMLMCSB = "80222";
    //目录级别不匹配
    public static final String MLJBBPP = "80223";
    //上级目录非文件夹
    public static final String SJMLBSWJJ = "80224";
    //所属来源与上级目录不匹配
    public static final String SSLYYSJMUBPP = "80225";
    //请于工作时间进行推送数据
    public static final String ISNOTGZR = "80226";
    //契约锁合同生成失败
    public static final String QYSHTSCSB = "80227";
    //请核实资金监管未到账！
    public static final String JYZJJGWDZ = "80228";

    //资金监管核验失败，交易编号为空！
    public static final String ZJJG_JYBH_NULL = "80229";

    /**
     * 生成订单频繁
     */
    public static final String SCDDPF = "80230";
    //获取预约人数的数量
    public static final String REDISSON_LOCK_YYRS = "redisson_lock_yyrs";
    //获取预约人数的数量是否已满
    public static final String REDISSON_LOCK_YYRSSFYM = "redisson_lock_yyrssfym";

    public static final Map<Object, String> RESP_INFO = new HashMap<Object, String>();


    static {
        RESP_INFO.put("2007361", "该功能仅对扬州市备案的律师开放");
        RESP_INFO.put("0090", "字典类型资源不存在");
        RESP_INFO.put("1111", "输入值存在非法字符");
        RESP_INFO.put("6666", "用户需要重新登录");
        RESP_INFO.put("4444", "解密错误");
        RESP_INFO.put("2333", "无权操作");
        RESP_INFO.put("2334", "保存数据失败");
        RESP_INFO.put("2335", "更新数据失败");
        RESP_INFO.put("2336", "删除数据失败");
        RESP_INFO.put("0000", "成功");
        RESP_INFO.put("0201", "该CA已经绑定过");
        RESP_INFO.put("0202", "CA证书不存在");
        RESP_INFO.put("0203", "CA绑定部门和用户所在部门不一致");
        RESP_INFO.put("0204", "CA绑定类型出错");
        RESP_INFO.put("0205", "该用户已经绑定过CA");
        RESP_INFO.put("0206", "证书密码错误，请检查！");
        RESP_INFO.put("0001", "参数为空");
        RESP_INFO.put("0002", "AES加密错误");
        RESP_INFO.put("0003", "token无效");
        RESP_INFO.put("0004", "参数错误");
        RESP_INFO.put("0005", "程序执行出错");
        RESP_INFO.put("0006", "数字签名不一致");
        RESP_INFO.put("0007", "data参数为空或json转对象错误");
        RESP_INFO.put("0008", "参数转对象失败");
        RESP_INFO.put("0009", "微信openid为空");
        RESP_INFO.put("0010", "来源与token来源不一致");
        RESP_INFO.put("0011", "获取共享数据失败");
        RESP_INFO.put("0012", "日期格式不正确");
        RESP_INFO.put("0013", "字典数据为空");
        RESP_INFO.put("0014", "获取token失败");
        RESP_INFO.put("0015", "http请求失败");
        RESP_INFO.put("0016", "发送短信过频，稍后再试");
        RESP_INFO.put("0017", "视频保存出错");
        RESP_INFO.put("0018", "音频保存出错");
        RESP_INFO.put("0019", "密码复杂度低，请输入8-20位同时包含数字，大小写英文的密码");
        RESP_INFO.put("0020", "获取access_token失败");
        RESP_INFO.put("0021", "access_token不能为空");
        RESP_INFO.put("0022", "access_token已过期");
        RESP_INFO.put("0023", "无效的access_token");
        RESP_INFO.put("0024", "配置不存在,请联系管理员");
        RESP_INFO.put("0025", "类型转换异常");
        RESP_INFO.put("0026", "资源不存在");
        RESP_INFO.put("0027", "资源非法");
        RESP_INFO.put("0028", "未获取到资源");
        RESP_INFO.put("0031", "您无权操作角色");
        RESP_INFO.put("0032", "您无权操作组织");
        RESP_INFO.put("0033", "您无权操作用户");
        RESP_INFO.put("0034", "角色非法");
        RESP_INFO.put("0035", "部门非法");
        RESP_INFO.put("0036", "不可删除管理角色");
        RESP_INFO.put("0037", "请求用户ID或者被操作人ID为空");
        RESP_INFO.put("0038", "角色已经存在");
        RESP_INFO.put("0039", "部门已经存在");
        RESP_INFO.put("0040", "部门不存在");
        RESP_INFO.put("0041", "角色不存在");
        RESP_INFO.put("0042", "不能自己作为自己的父部门");
        RESP_INFO.put("0043", "新建部门时父部门必传");
        RESP_INFO.put("0044", "获取部门信息失败");
        RESP_INFO.put("0045", "请用CA登录");
        RESP_INFO.put("0046", "资源菜单不合法");
        RESP_INFO.put("0047", "数据可见范围字典项非法");
        RESP_INFO.put("0048", "微信openID已存在");
        RESP_INFO.put("0049", "真实姓名为空");
        RESP_INFO.put("0050", "数据已存在");
        RESP_INFO.put("0051", "该人员新增窗口和登记中心与历史数据不一致");
        RESP_INFO.put("0052", "不动产权证号参数为空");
        RESP_INFO.put("0053", "不动产单元编号参数为空");
        RESP_INFO.put("0054", "不动产单元号参数为空");
        RESP_INFO.put("0055", "项目id参数为空");
        RESP_INFO.put("0056", "第三方接口执行失败");
        RESP_INFO.put("0057", "高拍仪开启失败");
        RESP_INFO.put("0058", "serviceId参数错误");
        RESP_INFO.put("0059", "完税信息无法撤销");
        RESP_INFO.put("0060", "取消税务申报失败");
        RESP_INFO.put("0061", "打印失败，未找到可用打印机，请检查");
        RESP_INFO.put("0062", "法人名称已经存在");
        RESP_INFO.put("0063", "法人证件号已经存在");
        RESP_INFO.put("0064", "用户名或证件号输入有误");
        RESP_INFO.put("0301", "指纹不存在");
        RESP_INFO.put("0302", "指纹不匹配");

        RESP_INFO.put("0101", "密码过于简单");
        RESP_INFO.put("0102", "原密码新密码相同");
        RESP_INFO.put("0103", "原密码错误");
        RESP_INFO.put("0104", "新密码与确认密码不一致");

        RESP_INFO.put("1001", "用户名为空");
        RESP_INFO.put("1002", "密码为空");
        RESP_INFO.put("1003", "不存在该用户名");
        RESP_INFO.put("10031", "会签人员账户未全部注册");
        RESP_INFO.put("10032", "已婚人员家庭成员必填");
        RESP_INFO.put("10033", "家庭成员名称必填");
        RESP_INFO.put("10034", "家庭成员证件号必填");
        RESP_INFO.put("10035", "家庭成员关系必填");
        RESP_INFO.put("10036", "微信、支付宝不允许机构或者管理员登录");
        RESP_INFO.put("10037", "婚姻状态校验错误");
        RESP_INFO.put("10038", "房屋套次校验错误");
        RESP_INFO.put("10039", "该账号已经在其他客户端登录");

        RESP_INFO.put("1004", "密码错误");
        RESP_INFO.put("1005", "电话号码为空");
        RESP_INFO.put("1006", "证件号为空");
        RESP_INFO.put("1007", "角色为空");
        RESP_INFO.put("1008", "登录名已存在");
        RESP_INFO.put("1009", "证件号已存在");
        RESP_INFO.put("1010", "不存在该用户");
        RESP_INFO.put("1011", "登录名和密码不为空");
        RESP_INFO.put("1012", "电话号码已存在，请用手机号验证码登录并修改密码");
        RESP_INFO.put("1013", "该登录名有多个用户，请联系管理员");
        RESP_INFO.put("1014", "用户被禁用");
        RESP_INFO.put("1016", "用户或邮箱不存在");
        RESP_INFO.put("1017", "用户为非管理员");
        RESP_INFO.put("1018", "密码输入错误次数过多");
        RESP_INFO.put("1019", "角色必须是普通用户");
        RESP_INFO.put("1020", "用户名密码错误");
        RESP_INFO.put("1021", "用户名已存在");
        RESP_INFO.put("1022", "用户GUID为空");
        RESP_INFO.put("1023", "用户登录错误次数过多,帐号已锁定");
        RESP_INFO.put("1024", "保存用户失败");
        RESP_INFO.put("1025", "机构名称已存在");
        RESP_INFO.put("1026", "获取用户信息失败");
        RESP_INFO.put("1027", "CA认证失败");
        RESP_INFO.put("1028", "用户角色信息为空");

        RESP_INFO.put("1029", "六位长度以上的密码，数字或者字母。（范围：数字、字母）");
        RESP_INFO.put("1030", "八位长度以上的密码，必须包含数字和字母。（范围：数字、字母）");
        RESP_INFO.put("1031", "八位长度以上的密码，必须包含数字、大写字母和小写字母。（范围：数字、字母）");
        RESP_INFO.put("1032", "8`20位长度的密码，必须包含数字，大小写字母。（范围：数字、字母）");

        RESP_INFO.put("1033", "八位长度以上的密码，必须包含数字、大写字母、小写字母和特殊字符(四种中任三种)。（范围：数字、字母、特殊字符）");
        RESP_INFO.put("1034", "八位长度以上的密码，必须包含数字、大写字母、小写字母和特殊字符。（范围：数字、字母、特殊字符）");
        RESP_INFO.put("1035", "8`16位长度的密码，必须包含数字、大写字母、小写字母和特殊字符。（范围：数字、字母、特殊字符）");

        RESP_INFO.put("1036", "登录密码到期,无法登陆系统,请您修改密码之后登录");
        RESP_INFO.put("1037", "传入用户信息和AccessToken不匹配");
        RESP_INFO.put("1038", "该账号已被锁定");
        RESP_INFO.put("1039", "用户名密码错误，请重新修改用户信息");
        RESP_INFO.put("1040", "用户未注册，请先注册");
        RESP_INFO.put("1041", "用户名或密码错误次数过多,已锁定");
        RESP_INFO.put("2001", "未查询到结果");
        RESP_INFO.put("2002", "申请信息为空,请重新申请");
        RESP_INFO.put("20020", "申请信息更新主键为空");
        RESP_INFO.put("20021", "受理编号为空");
        RESP_INFO.put("20022", "申请信息申请类型为空");
        RESP_INFO.put("20023", "申请信息不动产类型为空");
        RESP_INFO.put("20024", "申请信息创建用户为空或者不存在");
        RESP_INFO.put("20025", "管理员不允许创建申请信息");
        RESP_INFO.put("20026", "证书号为空");
        RESP_INFO.put("20027", "申请信息坐落为空");
        RESP_INFO.put("20028", "申请信息不动产单元号为空,请联系业务管理员,线下办理");
        RESP_INFO.put("20029", "申请信息面积为空");
        RESP_INFO.put("20030", "申请信息不动产权证号/房产证号为空,请联系业务管理员,线下办理");
        RESP_INFO.put("200301", "该不动产权证号已经创建过信息");
        RESP_INFO.put("200302", "该不动产单元号已经创建过信息");
        RESP_INFO.put("200303", "该买卖合同号已经创建过信息");
        RESP_INFO.put("200210", "申请信息更新主键为空");
        RESP_INFO.put("200211", "申请信息不存在");
        RESP_INFO.put("200212", "申请信息已经存在");
        RESP_INFO.put("200213", "登记系统查询异常,请联系管理员");
        RESP_INFO.put("200214", "登记系统TOKEN异常,请联系管理员");
        RESP_INFO.put("200215", "抵押申请推送失败");
        RESP_INFO.put("200216", "该房产处于查封状态,不允许抵押");
        RESP_INFO.put("200217", "该房产处于查封状态");
        RESP_INFO.put("200218", "该房产处于抵押状态");
        RESP_INFO.put("200219", "买卖合同编号为空,请联系业务管理员");
        RESP_INFO.put("200220", "证书来源不能为空,请联系业务管理员,线下办理");
        RESP_INFO.put("200221", "抵押证明号不允许为空,请联系业务管理员,线下办理");
        RESP_INFO.put("200222", "申请信息更新失败");
        RESP_INFO.put("200223", "抵押证明号不是当前用户,请联系业务管理员,线下办理");
        RESP_INFO.put("200224", "登记创建业务流程失败，请联系管理员");
        RESP_INFO.put("200225", "该抵押证明已经存在");
        RESP_INFO.put("200226", "产权证不匹配");
        RESP_INFO.put("200227", "申请类型不存在");
        RESP_INFO.put("200228", "申请信息不可撤回");
        RESP_INFO.put("200229", "申请信息不可删除");
        RESP_INFO.put("200230", "申请信息受理状态异常");
        RESP_INFO.put("200231", "申请信息不可补录附件");
        RESP_INFO.put("200232", "该合同存在查封或抵押信息，请重新确认");
        RESP_INFO.put("200233", "业务系统受理编号为空");
        RESP_INFO.put("200234", "请用本人或本部门用户登陆查询");
        RESP_INFO.put("200235", "该业务需到线下窗口办理");
        RESP_INFO.put("200236", "不存在印制号");
        RESP_INFO.put("200237", "自动办结失败");
        RESP_INFO.put("200238", "受理编号生成失败");
        RESP_INFO.put("200239", "该业务已推送登记，请核查");

        RESP_INFO.put("2003", "权利人为空");
        RESP_INFO.put("20031", "权利人名称为空");
        RESP_INFO.put("20032", "权利人证件种类为空");
        RESP_INFO.put("20033", "权利人证件号为空");
        RESP_INFO.put("20034", "权利人更新主键为空");
        RESP_INFO.put("20035", "权利人更新sqid为空");
        RESP_INFO.put("20036", "权利人和用户不匹配，请勿匹配他人的身份信息");
        RESP_INFO.put("20037", "权利人权利比例有误");
        RESP_INFO.put("20038", "义务人权利比例有误");
        RESP_INFO.put("20039", "权利人与义务人完全一致");
        RESP_INFO.put("20040", "权利人名称证件号验证失败");

        RESP_INFO.put("2004", "附件项目为空");
        RESP_INFO.put("20041", "附件数据为空");
        RESP_INFO.put("20042", "附件项目中附件类型不能为空");
        RESP_INFO.put("20043", "未查询到会签信息");
        RESP_INFO.put("20044", "存在未核验抵押人,提醒其核验后方可推送");
        RESP_INFO.put("20045", "共有方式错误，请重新核验");
        RESP_INFO.put("20046", "该不动产单元已核税");
        RESP_INFO.put("20047", "该授权码不存在，请核查！");
        RESP_INFO.put("20048", "该授权码已过期，请重新获取！");

        RESP_INFO.put("2005", "附件信息为空");
        RESP_INFO.put("20051", "附件图片流不能为空");
        RESP_INFO.put("20052", "附件名称不能为空");
        RESP_INFO.put("20053", "附件上传人不能为空");
        RESP_INFO.put("20054", "附件图片保存失败");
        RESP_INFO.put("20070", "附件大小超过限制");
        RESP_INFO.put("20100", "附件支持类型为空,请联系管理元");
        RESP_INFO.put("20101", "不支持该附件类型，请重新上传附件");
        RESP_INFO.put("20102", "附件不合格,请上传有效附件");
        RESP_INFO.put("200103", "申请信息需要预审但是尚未预审通过");
        RESP_INFO.put("200104", "当前件非线上办件，不能打印收件单");
        RESP_INFO.put("200105", "当前件未完成视频公证，暂时不可推送");
        RESP_INFO.put("200106", "该产权证未挂牌");
        RESP_INFO.put("200107", "该产权证存在租赁");
        RESP_INFO.put("20055", "EXCEL上传异常");
        RESP_INFO.put("00610", "附件展示失败");
        RESP_INFO.put("0065", "网络异常，请稍后再试");
        RESP_INFO.put("0066", "请用指纹登录");
        RESP_INFO.put("0067", "因恶意攻击已被禁用");

        RESP_INFO.put("20056", "您不符合申请条件，请核实后重新尝试");
        RESP_INFO.put("20057", "问询笔录录入失败");
        RESP_INFO.put("20058", "题库查询失败,或不存在该申请类型(权利人)题库");
        RESP_INFO.put("20059", "问询笔录录入异常,请核对信息是否正确");
        RESP_INFO.put("20060", "更新人脸识别认证状态失败");
        RESP_INFO.put("200600", "您的物权共有方式选择有误请重新选择");

        RESP_INFO.put("2006", "预约信息不存在");
        RESP_INFO.put("20061", "预约创建人（yyrbs）为空");
        RESP_INFO.put("20062", "预约人名称为空");
        RESP_INFO.put("20063", "预约人证件号为空");
        RESP_INFO.put("20064", "预约人联系电话为空");
        RESP_INFO.put("20065", "预约登记中心为空");
        RESP_INFO.put("20066", "预约登记中心不存在");
        RESP_INFO.put("20067", "预约时段为空");
        RESP_INFO.put("20068", "预约时段不存在");
        RESP_INFO.put("20069", "预约登记类型为空");
        RESP_INFO.put("200610", "预约登记类型不存在");
        RESP_INFO.put("200611", "预约来源不为空");
        RESP_INFO.put("200612", "该用户当天已预约，不可再预约");
        RESP_INFO.put("200613", "用户当前已存在该登记类型的预约，不可再预约");
        RESP_INFO.put("200614", "同一身份证号，" + AppConfig.getProperty("within_qxts") + "天之内取消满" + AppConfig.getProperty("canceltimes") + "次，" + AppConfig.getProperty("future_days") + "天之内不得再预约");
        RESP_INFO.put("200615", "预约创建人不存在");
        RESP_INFO.put("200616", "预约时间为空");
        RESP_INFO.put("200617", "当天预约取消次数达到上限");
        RESP_INFO.put("200618", "已存在预约信息");
        RESP_INFO.put("200619", "预约日期为节假日");
        RESP_INFO.put("200620", "获取日期失败");
        RESP_INFO.put("200621", "预约时段已满");
        RESP_INFO.put("200622", "预约发生错误，请刷新页面");
        RESP_INFO.put("200623", "不可以预约当天,请重新选择预约日期");
        RESP_INFO.put("200624", "未查询到部门代码");
        RESP_INFO.put("200625", "当前用户已加入预约黑名单，若需继续办理预约申请，请联系管理员");
        RESP_INFO.put("200626", "预约申请类型为空");
        RESP_INFO.put("200627", "一周有效预约不可以超过两次");
        RESP_INFO.put("200628", "该手机号当天当前预约日期已经预约过，请重新选择");
        RESP_INFO.put("200629", "当前预约日期错误");
        RESP_INFO.put("200630", "当前预约时段最多只能预约一次，请您选择其他预约时段预约");

        RESP_INFO.put("20071", "获取不到缴费信息");
        RESP_INFO.put("20072", "该业务已完成支付");
        RESP_INFO.put("20073", "生成订单失败");
        RESP_INFO.put("20074", "商户信息为空");
        RESP_INFO.put("20075", "缴费成功后的通知地址为空");
        RESP_INFO.put("20076", "订单参数为空");
        RESP_INFO.put("20077", "验证签名不通过");
        RESP_INFO.put("20078", "支付请求失败");
        RESP_INFO.put("20079", "付费方式为空");
        RESP_INFO.put("200710", "付费方式错误");
        RESP_INFO.put("200711", "支付方式为空");
        RESP_INFO.put("200712", "支付方式错误");
        RESP_INFO.put("200713", "订单不存在");
        RESP_INFO.put("200714", "订单金额有误");
        RESP_INFO.put("200715", "该用户无相关银行卡信息");
        RESP_INFO.put("200716", "银行卡信息为空");
        RESP_INFO.put("200717", "订单已缴费无法关闭");
        RESP_INFO.put("200718", "该银行卡已绑定，请选择其他银行卡");
        RESP_INFO.put("200719", "绑定银行卡失败");
        RESP_INFO.put("200720", "支付密码错误");
        RESP_INFO.put("200721", "支付失败");
        RESP_INFO.put("200722", "银行卡解绑失败");
        RESP_INFO.put("200723", "您有处于激活中的订单或该订单已完成缴费，请前往订单列表中进行查看");
        RESP_INFO.put("200724", "订单未支付成功");
        RESP_INFO.put("200725", "缴费信息推送失败");
        RESP_INFO.put("200726", "该缴费项无法缴费");
        RESP_INFO.put("200727", "该受理编号不存在缴费信息");
        RESP_INFO.put("200728", "该订单不允许取消关闭");
        RESP_INFO.put("200730", "退款失败");
        RESP_INFO.put("200731", "合计金额错误");
        RESP_INFO.put("200732", "不存在退款信息");
        RESP_INFO.put("200733", "未查询到税务信息");
        RESP_INFO.put("200734", "获取税务信息异常");
        RESP_INFO.put("200735", "未查询到税务信息明细");
        RESP_INFO.put("200736", "查询退款信息出错");
        RESP_INFO.put("200737", "查询未转开的税款信息为空");

        RESP_INFO.put("200740", "未查询到缴费人信息");
        RESP_INFO.put("200741", "纳税人识别号为空");
        RESP_INFO.put("200742", "推送税务失败");
        RESP_INFO.put("200743", "尚未获取税款明细，请等待");
        RESP_INFO.put("200744", "尚未获取三要素，请等待");
        RESP_INFO.put("200745", "缴款单作废失败");
        RESP_INFO.put("200746", "已缴费，删除/撤销申请需先进行退款");
        RESP_INFO.put("200747", "已缴费。不允许退回修改");
        RESP_INFO.put("200748", "已缴税，不允许退回修改");
        RESP_INFO.put("200749", "已缴费、已缴税。不允许退回修改");


        RESP_INFO.put("20081", "验证码错误");
        RESP_INFO.put("20082", "短信发送发生错误");
        RESP_INFO.put("20091", "证书查询受理编号为空");
        RESP_INFO.put("20092", "证书查询输入的权利人与扫描结果不一致");
        RESP_INFO.put("20093", "申请处于正在审核中，不可以再次申请");

        RESP_INFO.put("20094", "该产权未落宗或未匹配不动产单元号，请至中心落宗或者匹配不动产单元号");
        RESP_INFO.put("20095", "该产权匹配多个不动产单元号");

        RESP_INFO.put("20010", "暂无服务网点信息");
        RESP_INFO.put("30009", "上传证件和填写信息不一致,请重新上传证件!");
        RESP_INFO.put("30008", "身份验证异常");

        RESP_INFO.put("110001", "活体检测失败");
        RESP_INFO.put("110002", "人脸比对失败");
        RESP_INFO.put("110003", "人脸对比阈值过低");
        RESP_INFO.put("110004", "人脸比对获取结果错误");
        RESP_INFO.put("110005", "人脸比对二维码超时失效");
        RESP_INFO.put("110006", "人脸比对二维码查询结果为空，继续轮询");
        RESP_INFO.put("110007", "身份认证已完成");
        RESP_INFO.put("110008", "人脸核身业务类型为空");
        RESP_INFO.put("110009", "人脸核身使用次数超过限制");
        RESP_INFO.put("110010", "阿里人脸请求错误");
        RESP_INFO.put("110011", "阿里的人脸认证查询结果不正确");
        RESP_INFO.put("110012", "身份未认证，请前往支付宝进行认证");
        RESP_INFO.put("110013", "暂不支持个人以外的身份类型");

        RESP_INFO.put("12001", "需要重定向");
        RESP_INFO.put("12002", "政务一张网用户主键缺失");
        RESP_INFO.put("12003", "用户必须先完成实名认证");
        RESP_INFO.put("12004", "需要重新选择企业类型");
        RESP_INFO.put("12005", "请勿重复发起登录请求");
        RESP_INFO.put("12006", "该手机号码已被占用");

        RESP_INFO.put("210001", "服务已被评价过，不可再次评价");

        RESP_INFO.put("220001", "微信公众号通知信息推送失败");
        RESP_INFO.put("220002", "微信公众号信息通知模板id为空");
        RESP_INFO.put("220003", "微信公众号信息通知模板内容为空");

        RESP_INFO.put("230001", "视频问询声明数据不存在");
        RESP_INFO.put("230002", "视频问询声明中声明人为空");
        RESP_INFO.put("230003", "申请类型为空");
        RESP_INFO.put("230004", "视频问询原因为空");

        RESP_INFO.put("240001", "申请类型主键不存在");

        RESP_INFO.put("250001", "申请类型重复");
        RESP_INFO.put("250002", "CA字典项非法");
        RESP_INFO.put("250003", "字典项非法");

        RESP_INFO.put("260001", "登记系统创建失败");
        RESP_INFO.put("260002", "登记系统附件接收失败");
        RESP_INFO.put("260010", "public创建申请失败");
        RESP_INFO.put("260011", "public接受附件失败");

        RESP_INFO.put("270001", "获取UC用户信息失败");

        RESP_INFO.put("28001", "获取initCode失败");
        RESP_INFO.put("28002", "获取authCode失败");
        RESP_INFO.put("28003", "获取accessToken失败");
        RESP_INFO.put("28004", "获取userAccessToken失败");
        RESP_INFO.put("28005", "获取userInfo失败");
        RESP_INFO.put("29001", "微信快捷登录失败");
        RESP_INFO.put("29002", "微信快捷登录需要补充身份信息");
        RESP_INFO.put("30001", "验证江苏政务网ticket失败");
        RESP_INFO.put("30002", "验证江苏政务网token失败");
        RESP_INFO.put("30003", "获取政务网用户失败");
        RESP_INFO.put("30004", "暂不支持法人快捷登录");

        RESP_INFO.put("40001", "查询他人权利信息次数超限");
        RESP_INFO.put("40002", "查询他人权利信息不动产权证号长度不足");

        RESP_INFO.put("50001", "公示公告信息推送门户网站失败");

        RESP_INFO.put("60001", "");
        RESP_INFO.put("60002", "未查询到合同信息");
        RESP_INFO.put("60003", "未查询到房屋信息");
        RESP_INFO.put("60004", "房屋已办理产权信息");
        RESP_INFO.put("60005", "合同不存在");

        RESP_INFO.put("61001", "获取缴费明细失败");
        RESP_INFO.put("61002", "生成缴费订单失败");
        RESP_INFO.put("61003", "查询订单信息失败");
        RESP_INFO.put("61006", "一卡清获取对账单失败");
        RESP_INFO.put("61007", "该月结单号已经执行过批量开单");
        RESP_INFO.put("61008", "已生成过月结单号");
        RESP_INFO.put("61009", "请卖方先缴税，卖方缴税完成后，重新操作");
        RESP_INFO.put("610010", "POS机终端绑定失败");
        RESP_INFO.put("610011", "POS机终端绑定失败，设备已绑定");
        RESP_INFO.put("70001", "该银行部门权限已到期，不允许登入，请与不动产登记中心联系");

        RESP_INFO.put("80001", "当日查询次数已达上限，请明日再试");
        RESP_INFO.put("80002", "当月查询次数已达上限，请与不动产登记中心联系");
        RESP_INFO.put("80003", "当年查询次数已达上限，请与不动产登记中心联系");
        RESP_INFO.put("80004", "当周查询次数已达上限，请下周再试，或与不动产登记中心联系");

        RESP_INFO.put("80100", "接口参数为空或处理异常");
        RESP_INFO.put("80101", "印制号不存在或被删除");
        RESP_INFO.put("80102", "印制号存在，但是已经被使用");
        RESP_INFO.put("80103", "印制号存在、未使用，但是该印制号不在当前用户权限下");
        RESP_INFO.put("80104", "印制号存在、未使用，且在当前用户名下，可使用");
        RESP_INFO.put("80105", "该证书已经在登记系统打证");

        RESP_INFO.put("80106", "请先完成发证记录信息保存、打印操作");
        RESP_INFO.put("80107", "请先完成收费单信息保存、打印操作");
        RESP_INFO.put("80108", "合同备案信息撤销失败");

        RESP_INFO.put("80109", "请先完成一卡清缴费或一窗受理操作");
        RESP_INFO.put("80110", "暂无登记费明细，请耐心等待");
        RESP_INFO.put("80111", "暂无税款明细，请耐心等待");
        RESP_INFO.put("80112", "税费缴纳已完成，无法进行线上驳回");
        RESP_INFO.put("80113", "请确认是否已完成缴费缴库操作！");
        RESP_INFO.put("80114", "税款明细买卖双方未确认，请耐心等待");
        RESP_INFO.put("80115", "退款申请成功，请查询退款状态！");
        RESP_INFO.put("80116", "手机号码比对失败！");
        RESP_INFO.put("80117", "未获取到三要素信息");
        RESP_INFO.put("80118", "获取三要素信息不全");

        RESP_INFO.put("80200", "非税系统无响应");
        RESP_INFO.put("80201", "一卡清非税系统交互相关配置未添加");
        RESP_INFO.put("80202", "获取执收单位信息失败");
        RESP_INFO.put("80203", "获取缴费项目信息失败");
        RESP_INFO.put("80204", "获取收费账户信息失败");
        RESP_INFO.put("80205", "生成电子缴款单失败");
        RESP_INFO.put("80206", "查询应缴信息失败");
        RESP_INFO.put("80207", "非税系统响应信息中无相关数据");
        RESP_INFO.put("80208", "获取电子票据号码失败");
        RESP_INFO.put("80209", "换开电子票据失败");
        RESP_INFO.put("80210", "电子票据下载失败");
        RESP_INFO.put("80211", "请求一卡清，获取电子票据信息失败");
        RESP_INFO.put("80212", "客体信息查询次数超出当日限制");
        RESP_INFO.put("80213", "江苏省房地产交易税收一体化平台无响应");
        RESP_INFO.put("80214", "房产交易申报信息确认失败");
        RESP_INFO.put("80215", "市大数据局不动产登记信息查询失败");
        RESP_INFO.put("80216", "电子票据未生成");
        RESP_INFO.put("80217", "目录名称已存在");
        RESP_INFO.put("80218", "政务网注册失败");
        RESP_INFO.put("80219", "接口连接超时");
        RESP_INFO.put("80220", "请先进行统一认证");
        RESP_INFO.put("80221", "推送失败，该不动产单元存在抵押");
        RESP_INFO.put("80222", "获取上级目录失败");
        RESP_INFO.put("80223", "目录级别不匹配");
        RESP_INFO.put("80224", "上级目录不是文件夹");
        RESP_INFO.put("80225", "所属来源与上级目录不匹配");
        RESP_INFO.put("80226", "请于工作时间进行推送数据");
        RESP_INFO.put("80227", "契约锁合同生成失败");
        RESP_INFO.put("80228", "请核实资金监管未到账！");
        RESP_INFO.put("80229", "资金监管核验失败，交易编号为空！");
        RESP_INFO.put("80230", "该笔订单生成订单超过最大次数！");
        RESP_INFO.put("9998", "该功能正在开发中，请联系当地登记中心");
        /*自定义异常，不需要放内容，具体内容有代码内自定义*/
        RESP_INFO.put("9999", "");
    }
}
